package com.gogirl.application.store.store;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.shared.store.command.SignUpTrainingCommand;
import com.gogirl.shared.store.command.SubmitFeedbackCommand;
import com.gogirl.shared.store.command.SubmitWorksCommand;
import com.gogirl.shared.store.query.dto.CareerDTO;
import com.gogirl.shared.store.query.dto.TrainingStartClassDTO;
import com.gogirl.shared.store.query.dto.WorksDTO;
import com.gogirl.shared.store.query.qry.TrainingStartClassQuery;
import com.gogirl.shared.store.query.qry.WorksQuery;

public interface CareerCmdService {
    /**
     * 提交美甲作品
     *
     * @param cmd
     */
    void submitWorks(SubmitWorksCommand cmd);

    /**
     * 报名技能呢培训
     *
     * @param cmd
     */
    void signUpTraining(SignUpTrainingCommand cmd);

    /**
     * 提交技能培训反馈
     *
     * @param cmd
     */
    void submitFeedBack(SubmitFeedbackCommand cmd);

    Page<WorksDTO> queryWorks(WorksQuery qry);

    Page<TrainingStartClassDTO> queryPageClass(TrainingStartClassQuery qry);

    CareerDTO career(Integer technicianId);
}
