package com.gogirl.application.order.serve.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.gogirl.application.market.coupon.CouponCustomerRelevanceService;
import com.gogirl.application.market.coupon.CouponService;
import com.gogirl.application.market.coupon.MarketService;
import com.gogirl.application.market.timescard.TimesCardUsedRecordService;
import com.gogirl.application.order.serve.OrderManageService;
import com.gogirl.application.order.serve.OrderRecordService;
import com.gogirl.application.order.serve.OrderServeSkuService;
import com.gogirl.application.user.customer.CustomerBalanceService;
import com.gogirl.application.user.customer.CustomerService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.market.coupon.Coupon;
import com.gogirl.domain.market.coupon.CouponCustomerRelevance;
import com.gogirl.domain.market.timescard.TimesCardUsedRecord;
import com.gogirl.domain.order.serve.*;
import com.gogirl.domain.product.purchase.PurchaseSku;
import com.gogirl.domain.product.serve.BaseProduce;
import com.gogirl.domain.product.serve.BaseServe;
import com.gogirl.domain.product.serve.BaseType;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.domain.user.customer.Customer;
import com.gogirl.domain.user.customer.CustomerBalance;
import com.gogirl.domain.user.customer.CustomerDetail;
import com.gogirl.domain.user.customer.CustomerMessage;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.common.util.StringUtils;
import com.gogirl.infrastructure.mapper.order.serve.*;
import com.gogirl.infrastructure.mapper.product.purchase.PurchaseSkuMapper;
import com.gogirl.infrastructure.mapper.product.serve.BaseProduceMapper;
import com.gogirl.infrastructure.mapper.product.serve.BaseServeMapper;
import com.gogirl.infrastructure.mapper.product.serve.BaseTypeMapper;
import com.gogirl.infrastructure.mapper.product.serve.ProducePromotionTimeMapper;
import com.gogirl.infrastructure.mapper.store.store.StoreTechnicianMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerBalanceMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerMessageMapper;
import com.gogirl.infrastructure.service.subscribe.SubscribeService;
import com.gogirl.infrastructure.util.SessionUtils;
import com.gogirl.shared.member.order.command.CreateCommentCommand;
import com.gogirl.shared.member.order.command.OrderCommentCommand;
import com.gogirl.shared.order.serve.query.qry.ordermanage.ListOrderQuery;
import com.gogirl.shared.user.command.ConsumerCommand;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@Service
@Transactional(rollbackFor = Exception.class)
@Slf4j
public class OrderManageServiceImpl extends ServiceImpl<OrderManageMapper, OrderManage> implements OrderManageService {

    @Resource
    private OrderManageMapper orderManageMapper;
    @Resource
    private OrderServeMapper orderServeMapper;
    @Resource
    private BaseServeMapper baseServeMapper;
    @Resource
    private BaseTypeMapper baseTypeMapper;
    @Resource
    private BaseProduceMapper baseProduceMapper;
    @Resource
    private ScheduleManageMapper scheduleManageMapper;
    @Resource
    private CouponCustomerRelevanceService couponCustomerRelevanceService;
    @Resource
    private StoreTechnicianMapper storeTechnicianMapper;
    @Resource
    private TimesCardUsedRecordService timesCardUsedRecordService;
    @Resource
    private OrderServeDescribeMapper orderServeDescribeMapper;
    @Resource
    private PurchaseSkuMapper purchaseSkuMapper;
    @Resource
    private OrderServeSkuMapper orderServeSkuMapper;
    @Resource
    private OrderCommentMapper orderCommentMapper;
    @Resource
    private OrderCommentLabelMapper orderCommentLabelMapper;
    @Resource
    private OrderRecordMapper orderRecordMapper;
    @Resource
    private CustomerMessageMapper customerMessageMapper;
    @Resource
    private OrderRecordService orderRecordService;
    @Resource
    private CustomerBalanceMapper customerBalanceMapper;
    @Resource
    private CustomerBalanceService customerBalanceService;
    @Resource
    private OrderServeSkuService orderServeSkuService;
    @Resource
    private OrderServeDescribeRelevanceMapper orderServeDescribeRelevanceMapper;
    @Resource
    private CustomerService customerService;
    @Resource
    private SubscribeService subscribeService;
    @Resource
    private GogirlTokenService gogirlTokenService;
    @Resource
    private MarketService marketService;
    @Resource
    private ProducePromotionTimeMapper producePromotionTimeMapper;
    @Resource
    private CouponService couponService;
    @Resource
    private ScheduleServeMapper scheduleServeMapper;

    @Override
    public BigDecimal countSumPay(Integer customerId, Integer departmentId) {
        return orderManageMapper.countSumPay(customerId, departmentId);
    }

    @Override
    public void updateOrderManage(OrderManage param) {

        OrderManage orderManage = orderManageMapper.selectById(param.getId());
        List<OrderServe> orderServeList = orderServeMapper.selectList(new LambdaQueryWrapper<OrderServe>().eq(OrderServe::getOrderId, param.getId()));

        ScheduleManage scheduleManage = scheduleManageMapper.selectById(orderManage.getScheduledId());

        //更新订单服务、新增订单服务
        param.getListOrderServer().forEach(orderServeParam -> {

            BaseServe baseServe = baseServeMapper.selectById(orderServeParam.getServeId());
            BaseType baseType = baseTypeMapper.selectById(baseServe.getTypeId());

            if (StringUtils.isEmpty(orderServeParam.getTechnicianId())) {
                throw new RRException("请选择美甲师");
            }

            //1.新增订单服务
            if (orderServeParam.getId() == null) {

                OrderServe.OrderServeBuilder builder = OrderServe.builder()
                        //创建时间
                        .createTime(new Date())
                        //订单id
                        .orderId(param.getId())
                        //订单服务改价
                        .serveChangePrice(BigDecimal.ZERO);


                //服务信息
                builder.serveChangePrice(BigDecimal.ZERO)
                        .serveId(orderServeParam.getServeId())
                        .serveName(baseServe.getName())
                        .serveNumber(1)
                        .servePicturePath(baseServe.getPicturePath())
                        .servePrice(baseServe.getPrice())
                        .serveType(baseType.getName())
                        //服务价格
                        .price(baseServe.getPrice())
                        .payPrice(baseServe.getPrice())
                        .achievement(baseServe.getPrice());
//                        .leisureDiscountPrice(BigDecimal.ZERO);

                //款式信息
                if (orderServeParam.getProduceId() != null) {
                    BaseProduce baseProduce = baseProduceMapper.selectById(orderServeParam.getProduceId());
                    builder.produceBargainPrice(baseProduce.getBargainPrice())
                            .produceCurrentPrice(baseProduce.getCurrentPrice())
                            .produceId(baseProduce.getId())
                            .produceName(baseProduce.getName())
                            .producePicturePath(baseProduce.getPicturePath())

                            //有款式就设置价格为款式价格
                            .price(baseProduce.getCurrentPrice())
                            .payPrice(baseProduce.getCurrentPrice())
                            .achievement(baseProduce.getCurrentPrice())
                            .serveDuration(baseProduce.getServiceDuration());

                    ProducePromotionTime producePromotionTime = producePromotionTimeMapper
                            .queryByProduceId(orderServeParam.getProduceId(),
                                    new Date().toString());
                    //如果款式有活动价格
                    if (producePromotionTime != null && producePromotionTime.isPromotion()) {
                        builder.producePromotionTimeId(producePromotionTime.getId());
                        //活动价格
                        builder.promotionPrice(producePromotionTime.getPrice());
                        //价格活动价格
                        builder.price(producePromotionTime.getPrice());
                    }
                }
                //
                else {
                    builder.producePicturePath(null)
                            .produceBargainPrice(null)
                            .produceCurrentPrice(null)
                            .produceId(null)
                            .produceName(null)
                            .serveDuration(baseServe.getServiceDuration());
                }

                //价格
                builder.serveChangePrice(BigDecimal.ZERO)
                        .discountPrice(BigDecimal.ZERO);

                List<StoreTechnician> storeTechnicianList = storeTechnicianMapper.selectList(
                        new LambdaQueryWrapper<StoreTechnician>().in(StoreTechnician::getId, Lists.newArrayList(orderServeParam.getTechnicianId().split(",")))
                );
                builder.technicianId(orderServeParam.getTechnicianId())
                        .technicianName(storeTechnicianList.stream().map(StoreTechnician::getName).collect(Collectors.joining()))
                        .commentStatus(1)
                        .remark(orderServeParam.getRemark());

                //新增服务开始时间当前时间
                builder.startTime(new Date())
                        //新增服务开始时间结束时间
                        .endTime(new Date())
                        .scheduledTime(scheduleManage.getScheduledTime());

                if (orderServeParam.getServeChangePrice() != null) {
                    builder.serveChangePrice(orderServeParam.getServeChangePrice());
                }
                OrderServe orderServe = builder.build();
                orderServe.calcPrice();
                orderServeMapper.insert(orderServe);

            }

            //2.更新订单服务
            else {

                OrderServe orderServe = orderServeMapper.selectById(orderServeParam.getId());

                //服务改价
                orderServe.setServeChangePrice(orderServeParam.getServeChangePrice());
                //服务id
                orderServe.setServeId(orderServeParam.getServeId());
                //服务名称
                orderServe.setServeName(baseServe.getName());
                //服务数量
                orderServe.setServeNumber(1);
                //服务图片路径
                orderServe.setServePicturePath(baseServe.getPicturePath());
                //服务价格
                orderServe.setServePrice(baseServe.getPrice());
                //服务类型
                orderServe.setServeType(baseType.getName());
                //服务类型id
                orderServe.setServeTypeId(baseType.getId());
                //服务价格
                orderServe.setPrice(baseServe.getPrice());
                //服务业绩
                orderServe.setAchievement(baseServe.getPrice());
                orderServe.setDiscountPrice(BigDecimal.ZERO);

                if (orderServeParam.getProduceId() != null) {
                    BaseProduce baseProduce = baseProduceMapper.selectById(orderServeParam.getProduceId());
                    //款式原价
                    orderServe.setProduceBargainPrice(baseProduce.getBargainPrice());
                    //款式现价
                    orderServe.setProduceCurrentPrice(baseProduce.getCurrentPrice());
                    //款式Id
                    orderServe.setProduceId(baseProduce.getId());
                    //款式名称
                    orderServe.setProduceName(baseProduce.getName());
                    //款式图片
                    orderServe.setProducePicturePath(baseProduce.getPicturePath());
                    //价格
                    orderServe.setPrice(baseProduce.getCurrentPrice());
                    //实际支付金额
                    orderServe.setPayPrice(baseProduce.getCurrentPrice());
                    //业绩
                    orderServe.setAchievement(baseProduce.getCurrentPrice());
                    //服务时长=款式时长
                    orderServe.setServeDuration(baseProduce.getServiceDuration());

                    ProducePromotionTime producePromotionTime = producePromotionTimeMapper.queryByProduceId(
                            orderServeParam.getProduceId(),
                            orderServe.getStartTime().toString());
                    //如果款式有活动价格
                    if (producePromotionTime != null && producePromotionTime.isPromotion()) {
                        orderServe.setProducePromotionTimeId(producePromotionTime.getId());
                        //活动价格
                        orderServe.setPromotionPrice(producePromotionTime.getPrice());
                        //价格活动价格
                        orderServe.setPrice(producePromotionTime.getPrice());
                    }
                }
                //
                else {
                    //服务时长=服务时长
                    orderServe.setServeDuration(baseServe.getServiceDuration());

                    orderServe.setProduceBargainPrice(null);
                    //款式现价
                    orderServe.setProduceCurrentPrice(null);
                    //款式Id
                    orderServe.setProduceId(null);
                    //款式名称
                    orderServe.setProduceName(null);
                    //款式图片
                    orderServe.setProducePicturePath(null);

                    orderServe.setProducePromotionTimeId(null);

                    orderServe.setPromotionPrice(null);
                }

                if (orderServeParam.getServeChangePrice() != null) {
                    //订单服务改价
                    orderServe.setServeChangePrice(orderServeParam.getServeChangePrice());
                }

                List<StoreTechnician> storeTechnicianList = storeTechnicianMapper.selectList(
                        new LambdaQueryWrapper<StoreTechnician>().in(StoreTechnician::getId, Lists.newArrayList(orderServeParam.getTechnicianId().split(",")))
                );
                //美甲师id
                orderServe.setTechnicianId(orderServeParam.getTechnicianId());
                //美甲师姓名
                orderServe.setTechnicianName(storeTechnicianList.stream().map(StoreTechnician::getName).collect(Collectors.joining()));
                //订单服务评论状态
                orderServe.setCommentStatus(orderServeParam.getCommentStatus());
                //订单服务备注
                orderServe.setRemark(orderServeParam.getRemark());
                orderServe.calcPrice();
                orderServeMapper.updateById(orderServe);
            }
        });

        //3.删除订单服务
        List<Integer> deleteOrderServeIdList = (orderServeList.stream()
                .map(OrderServe::getId)
                .filter(id -> !param.getListOrderServer().stream()
                        .map(OrderServe::getId).collect(Collectors.toList())
                        .contains(id))
                .collect(Collectors.toList()));

        if (ListUtil.isNotEmpty(deleteOrderServeIdList)) {
            orderServeMapper.deleteBatchIds(deleteOrderServeIdList);
        }


        List<OrderServe> updatedOrderServeList = orderServeMapper.selectList(new LambdaQueryWrapper<OrderServe>().eq(OrderServe::getOrderId, orderManage.getId()));
        orderManage.setTotalPrice(updatedOrderServeList.stream().map(OrderServe::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
        orderManage.setChangePrice(updatedOrderServeList.stream().map(OrderServe::getServeChangePrice).reduce(BigDecimal.ZERO, BigDecimal::add));

        orderManage.setTotalPaymentAmount(orderManage.getTotalPrice().subtract(orderManage.getChangePrice()));
        orderManageMapper.updateById(orderManage);

        //订单结算
        marketService.setterOrder(orderManage.getId());

    }

    @Override
    public IPage<OrderManage> queryListOrder(ListOrderQuery param) {


        Page<OrderManage> pageParam = new Page<>(param.getPageNum(), param.getPageSize());
        LambdaQueryWrapper<OrderManage> wrapper = new LambdaQueryWrapper<>();

        if (StringUtils.isNotEmpty(param.getCustomerPhone())) {
            wrapper.like(OrderManage::getTelephone, param.getCustomerPhone());
        }
        if (param.getCustomerId() != null) {
            wrapper.and(wrapper2 -> wrapper.eq(OrderManage::getOrderUser, param.getCustomerId())
                    .or(wrapper3 -> wrapper3.eq(OrderManage::getPayUser, param.getCustomerId())));
        }
        if (param.getDepartmentId() != null) {
            wrapper.eq(OrderManage::getDepartmentId, param.getDepartmentId());
        }
        if (param.getStatus() != null) {
            wrapper.eq(OrderManage::getStatus, param.getStatus());
        }
        if (param.getShowUnCheck() != null && !param.getShowUnCheck()) {
            wrapper.ne(OrderManage::getStatus, OrderManage.STATUS_SYSTEM_UN_CHECK);
        }

        //noinspection unchecked
        wrapper.orderByDesc(OrderManage::getCreateTime);

        IPage<OrderManage> orderManagePage = this.page(pageParam, wrapper);


        if (ListUtil.isEmpty(orderManagePage.getRecords())) {
            return orderManagePage;
        }
        //通过id子查询
        List<Integer> orderIdList = orderManagePage.getRecords().stream().map(OrderManage::getId).collect(Collectors.toList());

        //in查询替换mybatis-resultMap-join查询分页的 服务详情
        List<OrderServe> orderServeList = orderServeMapper.selectList(new LambdaQueryWrapper<OrderServe>().in(OrderServe::getOrderId, orderIdList));
        Map<Integer, List<OrderServe>> orderServeMap = orderServeList.stream().collect(Collectors.groupingBy(OrderServe::getOrderId));

        //预约详情
        List<ScheduleManage> scheduleManageList = scheduleManageMapper.selectList(new LambdaQueryWrapper<ScheduleManage>().in(ScheduleManage::getOrderId, orderIdList));
        Map<Integer, List<ScheduleManage>> scheduledManageMap = scheduleManageList.stream()
                .filter(scheduleManage -> scheduleManage.getOrderId() != null)
                .collect(Collectors.groupingBy(ScheduleManage::getOrderId));

        List<OrderRecord> orderRecordList = orderRecordService.list(new LambdaQueryWrapper<OrderRecord>().in(OrderRecord::getOrderServeId, orderServeList.stream().map(OrderServe::getId).collect(Collectors.toList())));
        Map<Integer, List<OrderRecord>> orderRecordMap = orderRecordList.stream().collect(Collectors.groupingBy(OrderRecord::getOrderServeId));

        orderManagePage.getRecords().forEach(orderManage -> {
            orderManage.setListOrderServer(orderServeMap.get(orderManage.getId()));
            List<ScheduleManage> list = scheduledManageMap.get(orderManage.getId());
            if (ListUtil.isNotEmpty(list)) {
                orderManage.setScheduleManage(list.stream().findAny().orElse(null));
            }
            if (ListUtil.isNotEmpty(orderManage.getListOrderServer())) {
                orderManage.getListOrderServer().forEach(orderServe -> {
                    if (orderServe.getEndTime() != null && orderServe.getStartTime() != null) {
                        orderServe.setActualServeDuration((int) (orderServe.getEndTime().getTime() -
                                orderServe.getStartTime().getTime()) / 1000 / 60);
                    }
                    if (ListUtil.isNotEmpty(orderRecordMap.get(orderServe.getId()))) {
                        orderServe.setOrderRecord(orderRecordMap.get(orderServe.getId()).stream().findAny().orElse(null));
                    }
                });
            }
        });
        orderManagePage.setRecords(orderManagePage.getRecords()
                .stream()
                .filter(var -> ListUtil.isNotEmpty(var.getListOrderServer()))
                .collect(Collectors.toList()));

        return orderManagePage;
    }

    @Override
    public void checkOrder(Integer orderId) {
        OrderManage orderManage = orderManageMapper.selectById(orderId);
        if (orderManage.getStatus() != 11) {
            throw new RRException("订单状态异常");
        }
        orderManage.setStatus(2);
        orderManageMapper.updateById(orderManage);

        List<OrderServe> orderServeList = orderServeMapper.selectList(new LambdaQueryWrapper<OrderServe>().eq(OrderServe::getOrderId, orderId));
        OrderServe orderServe = orderServeList.get(0);
        String name = orderServe.getServeName();
        if (StringUtils.isNotEmpty(orderServe.getProduceName())) {
            name = orderServe.getProduceName();
        }
        Customer customer = customerService.selectByCustomerId(orderManage.getOrderUser());

        subscribeService.sendOrderPayNotifyMsg(orderId,
                customer.getOpenid1(),
                name,
                orderManage.getOrderNo(),
                orderManage.getTotalPaymentAmount(),
                customer.getRealName());
    }

    @Override
    public void recordOrderServeData(OrderServe param) {
        if (param == null || param.getId() == null) {
            throw new RRException("orderServeId不能为空");
        }

        //更新已选择的款式
        if (param.getProduceId() != null) {
            OrderServe orderServe = orderServeMapper.selectById(param.getId());
            BaseProduce baseProduce = baseProduceMapper.selectById(param.getProduceId());

            //step1.更新订单对应的款式
            orderServe.setProduceId(baseProduce.getId());
            orderServe.setProduceName(baseProduce.getName());
            orderServe.setProduceBargainPrice(baseProduce.getBargainPrice());
            orderServe.setProduceCurrentPrice(baseProduce.getCurrentPrice());
            orderServe.setProducePicturePath(baseProduce.getPicturePath());
            orderServeMapper.updateById(orderServe);

            //step2.清除订单详情原有的sku
            orderServeSkuMapper.deleteByOrderServeId(param.getId());


            List<PurchaseSku> purchaseSkuList = purchaseSkuMapper.selectByProduceId(orderServe.getProduceId());
            List<OrderServeSku> orderServeSkuList = purchaseSkuList.stream()
                    .map(purchaseSku -> {
                        OrderServeSku orderServeSku = OrderServeSku.builder()
                                //订单详情id
                                .orderServeId(param.getId())
                                //skuId
                                .skuId(purchaseSku.getId())
                                //skuName
                                .skuName(purchaseSku.getSkuName())
                                //sku类型
                                .type(purchaseSku.getSkuType())
                                .build();
                        return orderServeSku;
                    }).collect(Collectors.toList());

            //step3.绑定订单款式对应的sku到订单详情
            orderServeSkuService.saveBatch(orderServeSkuList);
        }


        //插入录入的色号
        if (ListUtil.isNotEmpty(param.getListOrderServeSku())) {

            //step1.删除已录入的色号
            orderServeSkuMapper.deleteByOrderServeId(param.getId());

            //step2.绑定订单款式对应的sku到订单详情
            List<PurchaseSku> purchaseSkuList = purchaseSkuMapper.selectList(new LambdaQueryWrapper<PurchaseSku>().in(PurchaseSku::getId,
                    param.getListOrderServeSku().stream().map(orderServeSku -> orderServeSku.getPurchaseSku().getId()).collect(Collectors.toList())));

            List<OrderServeSku> orderServeSkuList = purchaseSkuList.stream()
                    .map(purchaseSku -> {
                        OrderServeSku orderServeSku = OrderServeSku.builder()
                                .orderServeId(param.getId())
                                .skuId(purchaseSku.getId())
                                .skuName(purchaseSku.getSkuName())
                                .type(purchaseSku.getSkuType())
                                .build();
                        return orderServeSku;
                    }).collect(Collectors.toList());
            orderServeSkuService.saveBatch(orderServeSkuList);
        }


        //更新订单服务描述
        List<OrderServeDescribe> orderServeDescribeList = param.getListOrderServeDescribe();
        if (ListUtil.isNotEmpty(orderServeDescribeList)) {
            //删除已经录入的描述
            orderServeDescribeRelevanceMapper.deleteByOrderServeId(param.getId());
            //插入已经录入的描述
            List<OrderServeDescribeRelevance> orderServeDescribeRelevanceList = orderServeDescribeList.stream()
                    .map(orderServeDescribe -> {
                        OrderServeDescribeRelevance orderServeDescribeRelevance = OrderServeDescribeRelevance.builder()
                                .describeId(orderServeDescribe.getId())
                                .orderServeId(param.getId())
                                .build();
                        return orderServeDescribeRelevance;
                    }).collect(Collectors.toList());
            orderServeDescribeRelevanceMapper.insertList(orderServeDescribeRelevanceList);
        }

    }

    @Override
    public void recordOrderData(Integer orderId, String remark, String userFeedback, String picturePath, String afterSaleIsBuyCard, String afterSaleBuyCardReason) {


        OrderManage orderManage = orderManageMapper.selectById(orderId);

        //订单信息
        orderManage.setRemark(remark);
        orderManage.setAfterSaleIsBuyCard(afterSaleIsBuyCard);
        orderManage.setAfterSaleBuyCardReason(afterSaleBuyCardReason);
        orderManageMapper.updateById(orderManage);

        //订单录入信息
        List<OrderServe> orderServeList = orderServeMapper.selectList(new LambdaQueryWrapper<OrderServe>().eq(OrderServe::getOrderId, orderManage.getId()));

        for (OrderServe orderServe : orderServeList) {
            OrderRecord orderRecord = orderRecordMapper.selectOne(new LambdaQueryWrapper<OrderRecord>().eq(OrderRecord::getOrderServeId, orderServe.getId()));
            if (orderRecord == null) {
                orderRecord = new OrderRecord();
            }

            orderRecord.setOrderServeId(orderServe.getId());
            //美甲师备注
            orderRecord.setTechnicianFeedback(remark);
            //用户反馈
            orderRecord.setUserFeedback(userFeedback);
            //客照
            orderRecord.setPicturePath(picturePath);
            orderRecordService.saveOrUpdate(orderRecord);

            //set 计算完整度
            orderServe.setOrderRecord(orderRecord);
        }
        orderManage.setListOrderServer(orderServeList);

        Customer customer = customerService.getById(orderManage.getOrderUser());

        //订单数据完整度
        double dataRate = this.countOrderDataRate(customer, orderManage);
        orderManage.setDataIntegrity(dataRate);
        orderManageMapper.updateById(orderManage);
    }

    @Override
    public Map<String, Object> queryCustomerOrder(String token, Integer customerId, Integer pageNum, Integer pageSize) {
        GogirlToken gogirlToken = gogirlTokenService.getByToken(token);

        IPage<OrderManage> page = new Page<>(pageNum, pageSize);

        //1、分页查询订单
        page = orderManageMapper.selectPage(page, new LambdaQueryWrapper<OrderManage>()
//                .eq(OrderManage::getDepartmentId, gogirlToken.getDepartmentId())
                .and(wrapper -> wrapper
                        .eq(OrderManage::getOrderUser, customerId)
                        .or(wrapper2 -> wrapper2
                                .eq(OrderManage::getPayUser, customerId)))
                .orderByDesc(OrderManage::getCreateTime));

        for (OrderManage orderManage : page.getRecords()) {
            //2、订单详情
            List<OrderServe> orderServeList = orderServeMapper.selectList(new LambdaQueryWrapper<OrderServe>().eq(OrderServe::getOrderId, orderManage.getId()));
            orderManage.setListOrderServer(orderServeList);

            //3、订单客照
            Set<String> images = orderServeList.stream()
                    .map(orderServe -> orderRecordMapper.selectOne(new LambdaQueryWrapper<OrderRecord>().eq(OrderRecord::getOrderServeId, orderServe.getId())))
                    .filter(Objects::nonNull)
                    .map(OrderRecord::getPicturePath)
                    .filter(Objects::nonNull)
                    .map(picturePath -> Lists.newArrayList(picturePath.split(",")))
                    .flatMap(List::stream)
                    .collect(Collectors.toSet());
            orderManage.setImages(images);

            //4、订单会员信息
            Customer customer = customerService.getById(orderManage.getOrderUser());
            orderManage.setCustomer(customer);

            //5、支付用户信息
            Customer payCustomer = customerService.getById(orderManage.getPayUser());
            orderManage.setPayCustomer(payCustomer);

            //6、订单服务款式
            orderServeList.forEach(orderServe -> {
                //订单详情 款式sku
                List<OrderServeSku> orderServeSkuList = orderServeSkuMapper.selectList(new LambdaQueryWrapper<OrderServeSku>().eq(OrderServeSku::getOrderServeId, orderServe.getId()));
                orderServe.setListOrderServeSku(orderServeSkuList);

                //订单详情描述
                List<OrderServeDescribe> orderServeDescribeList = orderServeDescribeMapper.selectByOrderServeId(orderServe.getId());
                orderServe.setListOrderServeDescribe(orderServeDescribeList);
            });
        }

        //7、聚合结果
        Map<String, Object> map = new HashMap<>();
        map.put("pageInfo", page);
        map.put("orderTimes", page.getTotal());
        map.put("sumPay", this.countSumPay(customerId, gogirlToken.getDepartmentId()));

        return map;
    }

    @Override
    public List<OrderServe> addOrModifyOrderComment(CreateCommentCommand cmd) {


        OrderManage orderManage = this.queryOrderForComment(cmd.getOrderId());

        if (!orderManage.getStatus().equals(OrderManage.STATUS_UN_COMMENT)) {
            throw new RRException("订单状态异常");
        }
        List<OrderServe> orderServeList = orderServeMapper.selectList(new LambdaQueryWrapper<OrderServe>().eq(OrderServe::getOrderId, orderManage.getId()));


        ScheduleManage scheduleManage = scheduleManageMapper.selectById(orderManage.getScheduledId());
        List<ScheduleServe> scheduleServeList = scheduleServeMapper.selectList(new LambdaQueryWrapper<ScheduleServe>()
                .eq(ScheduleServe::getSchId, scheduleManage.getId())
                .eq(ScheduleServe::getMainServeId, null));

        //主服务id
        List<Integer> scheduledServeServeIds = scheduleServeList.stream().map(ScheduleServe::getServeId).collect(Collectors.toList());

        //待评论的主服务ID
        List<Integer> orderServeIds = orderServeList.stream()
                .filter(orderServe -> scheduledServeServeIds.contains(orderServe.getServeId()))
                .map(OrderServe::getId)
                .collect(Collectors.toList());

        //发表评论的服务id
        List<Integer> commandOrderServeIds = cmd.getCommentList().stream().map(OrderCommentCommand::getOrderServeId).collect(Collectors.toList());

        //2、插入评论
        cmd.getCommentList()
                .forEach(orderCommentCommand -> {

                    OrderComment orderComment = new OrderComment();
                    orderComment.setId(orderCommentCommand.getId());
                    orderComment.setLabelSticker(orderCommentCommand.getLabelSticker());
                    orderComment.setLevel(orderCommentCommand.getLevel());
                    orderComment.setOrderId(orderCommentCommand.getOrderId());
                    orderComment.setOrderServeId(orderCommentCommand.getOrderServeId());
                    orderComment.setPicturePath(orderCommentCommand.getPicturePath());
                    orderComment.setRemark(orderCommentCommand.getRemark());
                    orderComment.setTechnicianId(orderCommentCommand.getTechnicianId());

                    orderComment.setFinishTime(new Date());
                    if (StringUtils.isNotEmpty(orderComment.getLabelSticker())) {
                        //设置评论标签关联
                        List<OrderCommentLabel> orderCommentLabelList = orderCommentLabelMapper.selectBatchIds(Lists.newArrayList(orderComment.getLabelSticker().split(",")).stream().map(Integer::valueOf).collect(Collectors.toList()));
                        orderComment.setListOrderCommentLabel(orderCommentLabelList);
                    }

                    orderComment.setOrderId(orderManage.getId());
                    orderComment.setCreateTime(new Date());
                    orderComment.setStatus(2);

                    if (orderComment.getId() == null) {
                        orderCommentMapper.insert(orderComment);
                    } else {
                        orderCommentMapper.updateById(orderComment);
                    }
                    //3、更新评论分数
                    OrderServe orderServe = orderServeMapper.selectById(orderComment.getOrderServeId());
                    orderServe.setCommentScore(orderCommentCommand.getOrderServeCommentScore());
                    orderServeMapper.updateById(orderServe);
                });

        orderManage.setStatus(OrderManage.STATUS_FINISHED);
        orderManage.setFinishTime(new Date());

        //订单已完成
        orderManageMapper.updateById(orderManage);
        Coupon coupon = couponService.getOne(new LambdaQueryWrapper<Coupon>().eq(Coupon::getName, "评价礼券"));
        if (coupon != null) {
            couponService.sendCoupon(coupon.getId(), orderManage.getOrderUser());
        }

        return orderManage.getListOrderServer();
    }

    @Override
    public void confirmOrder(Integer orderId, Integer payType, Integer technicianId) {

        log.info("***美甲师发起收款***，美甲师id: {},订单id: {}", technicianId, orderId);

        String payTypeStr;
        OrderManage orderManage = this.queryOrder(orderId);
        if (orderManage.getStatus() == 3 || orderManage.getStatus() == 4) {
            throw new RRException("订单状态异常");
        }

        Customer customer = customerService.getById(orderManage.getOrderUser());
        CustomerBalance customerBalance = customerBalanceService.getCustomerBalance(orderManage.getOrderUser());


        //设置订单折扣详情
        log.info("设置订单折扣详情 orderManageDTO {}", orderManage.getId());

        //
        if (payType.equals(2)) {
            log.info("**美甲师余额收款**，订单id: {}", orderId);
            payTypeStr = "余额收款";
            if (customerBalance.getBalance() < orderManage.getTotalPaymentAmount().intValue() * 100) {
                throw new RRException("余额不足");
            }
            ConsumerCommand consumerCmd = ConsumerCommand.builder()
                    .amount(orderManage.getTotalPaymentAmount().multiply(new BigDecimal(100)).intValue())
                    .customerId(orderManage.getOrderUser())
                    .departmentId(orderManage.getDepartmentId())
                    .orderId(orderId)
                    .orderStatus(orderManage.getStatus())
                    .build();

            log.info("余额扣除开始");
            customerBalanceService.consumer(consumerCmd);
            log.info("余额扣除结束");

            orderManage.setStatus(OrderManage.STATUS_UN_COMMENT);
            orderManage.setPaymentType(payType);
            orderManageMapper.updateById(orderManage);
        } else if (payType.equals(5)) {
            log.info("**美甲师pos机收款**，订单id: {}", orderId);
            payTypeStr = "pos机收款";

            orderManage.setStatus(OrderManage.STATUS_UN_COMMENT);
            orderManage.setPaymentType(payType);
            orderManageMapper.updateById(orderManage);

        } else if (payType.equals(10)) {

            payTypeStr = "免单" + "";
            //状态更新为待评论
            orderManage.setStatus(OrderManage.STATUS_UN_COMMENT);
            orderManage.setPaymentType(OrderManage.PAYMENT_FREE);
            this.updateById(orderManage);
        }


        //余额pos收款
        else if (payType.equals(13)) {
            log.info("**美甲师pos机余额收款**，订单id: {}", orderId);
            payTypeStr = "美甲师pos机余额收款";

            List<MultiPaymentType> multiPaymentTypeList = JsonUtilByFsJson.jsonToList(orderManage.getMultiplePaymentType(), MultiPaymentType.class);
            ConsumerCommand consumerCmd = ConsumerCommand.builder()
                    .amount(multiPaymentTypeList.stream().filter(multiPaymentType ->
                            multiPaymentType.getType() == 2).map(multiPaymentType -> multiPaymentType.getPrice().intValue() * 100).mapToInt(Integer::intValue).sum())
                    .customerId(orderManage.getOrderUser())
                    .departmentId(orderManage.getDepartmentId())
                    .orderId(orderId)
                    .orderStatus(orderManage.getStatus())
                    .build();

            log.info("余额扣除开始");
            customerBalanceService.consumer(consumerCmd);
            log.info("余额扣除结束");

            //状态更新为待评论
            orderManage.setStatus(3);
            orderManage.setPaymentType(13);
            this.updateById(orderManage);

        }
        //不支持的收款方式
        else {
            throw new RRException("不支持的收款方式");
        }
        //支付时间
        orderManage.setPayTime(new Date());
        //支付用户等于下单用户
        orderManage.setPayUser(orderManage.getOrderUser());
        //非朋友代付
        orderManage.setIsFriendPay(2);
        //发送订阅消息
        subscribeService.sendPaySuccessMsg(orderId, customer.getOpenid1(), payTypeStr, new Date(), orderManage.getTotalPaymentAmount(), new BigDecimal(customerBalance.getBalance() / 100));

        this.updateById(orderManage);
    }

    @Override
    public void notifyBalanceWxPayOrder(WxPayOrderNotifyResult result) {
        String wxScheduleOrderNo = result.getOutTradeNo();
        String orderNo = wxScheduleOrderNo.substring(6);

        OrderManage orderManage = this.queryOrderByOrderNo(orderNo);


        log.info("更新订单状态");
        if (!orderManage.getStatus().equals(OrderManage.STATUS_UN_PAY)) {
            throw new RRException("订单状态异常");
        }
        //订单状态 待评价
        orderManage.setStatus(OrderManage.STATUS_UN_COMMENT);

        //支付方式
        orderManage.setPaymentType(12);
        orderManage.setPayTime(new Date());
        orderManage.setUpdateTime(new Date());

        Customer payCustomer = customerService.getByOpenid1(result.getOpenid());
        //支付用户
        orderManage.setPayUser(payCustomer.getId());
        //是否朋友支付
        orderManage.setIsFriendPay(payCustomer.getId().equals(orderManage.getOrderUser()) ? 2 : 1);
        this.updateById((orderManage));


        log.info("扣除余额");
        CustomerBalance customerBalance = customerBalanceMapper.selectOne(new LambdaQueryWrapper<CustomerBalance>()
                .eq(CustomerBalance::getCustomerId, orderManage.getOrderUser()));

        BigDecimal balanceAmount = new BigDecimal(customerBalance.getBalance()).divide(new BigDecimal(100), 2, BigDecimal.ROUND_HALF_UP);
        BigDecimal wxAmount = orderManage.getTotalPaymentAmount().subtract(balanceAmount);

        MultiPaymentType wxMultiPaymentType = MultiPaymentType.builder()
                .price(wxAmount)
                .type(1).build();
        MultiPaymentType balanceMultiPaymentType = MultiPaymentType.builder()
                .price(balanceAmount)
                .type(2).build();
        orderManage.setMultiplePaymentType(JsonUtilByFsJson.beanToJson(Lists.newArrayList(wxMultiPaymentType, balanceMultiPaymentType)));


        ConsumerCommand consumerCmd = ConsumerCommand.builder()
                .amount(customerBalance.getBalance())
                .customerId(orderManage.getOrderUser())
                .departmentId(orderManage.getDepartmentId())
                .orderId(orderManage.getId())
                .orderStatus(orderManage.getStatus())
                .build();
        customerBalanceService.consumer(consumerCmd);

        marketService.setterOrder(orderManage.getId());
        orderManageMapper.updateById(orderManage);
    }

    @Override
    public void notifyWxPayOrder(WxPayOrderNotifyResult result) {
        String wxScheduleOrderNo = result.getOutTradeNo();
        String orderNo = wxScheduleOrderNo.substring(6);
        OrderManage orderManage = this.queryOrderByOrderNo(orderNo);

        /*1.更新订单状态*/
        log.info("设置订单折扣详情 orderManageDTO {}", orderManage);

        log.info("更新订单状态");
        if (!orderManage.getStatus().equals(OrderManage.STATUS_UN_PAY)) {
            throw new RRException("订单状态异常");
        }
        //订单状态 待评价
        orderManage.setStatus(OrderManage.STATUS_UN_COMMENT);

        //支付方式
        orderManage.setPaymentType(OrderManage.PAYMENT_WX);
        //支付时间
        orderManage.setPayTime(new Date());
        //更新时间
        orderManage.setUpdateTime(new Date());

        //支付用户
        Customer customer = customerService.getByOpenid1(result.getOpenid());
        //支付用户
        orderManage.setPayUser(customer.getId());
        //是否朋友代付
        orderManage.setIsFriendPayByPayUserAndOrderUser();
        this.updateById(orderManage);

        /*2.更新卡券状态*/
        marketService.setterOrderMarket(orderManage.getId());
    }

    @Override
    public OrderManage queryOrderForComment(Integer id) {

        OrderManage orderManage = this.getById(id);
        ScheduleManage scheduleManage = scheduleManageMapper.selectById(orderManage.getScheduledId());
        List<ScheduleServe> scheduleServeList = scheduleServeMapper.selectList(new LambdaQueryWrapper<ScheduleServe>().eq(ScheduleServe::getSchId, scheduleManage.getId()));
        List<OrderServe> orderServeList = orderServeMapper.selectList(new LambdaQueryWrapper<OrderServe>().eq(OrderServe::getOrderId, orderManage.getId()));
        orderServeList = orderServeList.stream()
                .filter(orderServe -> scheduleServeList.stream()
                        .filter(scheduleServe -> scheduleServe.getMainServeId() == null)
                        .map(ScheduleServe::getServeId)
                        .collect(Collectors.toList())
                        .contains(orderServe.getServeId()))
                .collect(Collectors.toList());

        orderServeList.forEach(orderServe -> {
            OrderComment orderComment = orderCommentMapper.selectOne(new LambdaQueryWrapper<OrderComment>().eq(OrderComment::getOrderId, id)
                    .eq(OrderComment::getOrderServeId, orderServe.getId()));
            List<Integer> technicianIds = Lists.newArrayList(orderServe.getTechnicianId().split(",")).stream().map(Integer::valueOf).collect(Collectors.toList());
            List<StoreTechnician> storeTechnicianList = storeTechnicianMapper.selectBatchIds(technicianIds);
            orderServe.setListTechnicianManage(storeTechnicianList);
        });
        orderManage.setListOrderServer(orderServeList);
        return orderManage;

    }

    @Override
    public void friendPayOrder(Integer orderId, String phone) {

        //1、订单状态检查
        OrderManage orderManage = this.queryOrder(orderId);
        if (!orderManage.getStatus().equals(OrderManage.STATUS_UN_PAY)) {
            throw new RRException("订单状态异常");
        }

        //2、朋友用户检查
        Integer currentCustomerId = SessionUtils.getCustomerToken().getCustomerId();
        Customer customer = customerService.selectByPhone(phone);
        if (customer == null) {
            throw new RRException(500, "用户不存在");
        }

        //3、发送代付消息
        Map<String, Object> params = new HashMap<>();
        params.put(CustomerMessage.PARAM_FRIEND_PAY_ORDER_ID, orderId);
        params.put(CustomerMessage.PARAM_FRIEND_PAY_CUSTOMER_ID, currentCustomerId);
        String paramsJson = JsonUtilByFsJson.beanToJson(params);

        List<CustomerMessage> list = customerMessageMapper.selectList(
                new LambdaQueryWrapper<CustomerMessage>().eq(CustomerMessage::getParamsJson, paramsJson)
        );

        //避免重复发送
        if (ListUtil.isEmpty(list)) {
            CustomerMessage customerMessage = CustomerMessage.builder()
                    .customerId(customer.getId())
                    .header("代付订单提醒")
                    .paramsJson(paramsJson)
                    .status(CustomerMessage.STATUS_UN_READ)
                    .type(CustomerMessage.TYPE_FRIEND_SCHEDULE_PAY)
                    .build();
            //保存消息
            customerMessageMapper.insert(customerMessage);
        }
    }

    @Override
    public OrderManage queryOrder(Integer id) {
        //1、getById
        OrderManage orderManage = this.getById(id);
        //2、聚合订单详情
        return this.aggregateOrderManage(orderManage);
    }

    @Override
    public OrderManage queryOrderByOrderNo(String orderNo) {
        //1、根据订单号查询订单
        OrderManage orderManage = this.getOne(new LambdaQueryWrapper<OrderManage>()
                .eq(OrderManage::getOrderNo, orderNo));
        //2、聚合订单详情
        return this.aggregateOrderManage(orderManage);
    }


    @Override
    public Double countOrderDataRate(Customer c, OrderManage om) {
        double dataRate = 0;

        if (c != null && c.getCustomerDetail() != null) {
            CustomerDetail cd = c.getCustomerDetail();
            if (cd.getAge() != null && cd.getAge() != 0) {
                dataRate += 10;
            }
            if (cd.getJob() != null && !cd.getJob().isEmpty()) {
                dataRate += 10;
            }
            if (cd.getPreference() != null && !cd.getPreference().isEmpty()) {
                dataRate += 10;
            }
            if (cd.getCharacter() != null && !cd.getCharacter().isEmpty()) {
                dataRate += 10;
            }
        }

        if (om != null) {
            List<OrderServe> listos = om.getListOrderServer();

            if (listos != null) {
                String userFeedback = null;
                String technicianFeedback = null;
                String picturePath = null;

                for (OrderServe os : listos) {
                    if (os != null) {
                        OrderRecord or = os.getOrderRecord();
                        if (or != null) {
                            if (or.getUserFeedback() != null && !or.getUserFeedback().isEmpty()) {
                                userFeedback = or.getUserFeedback();
                            }
                            if (or.getTechnicianFeedback() != null && !or.getTechnicianFeedback().isEmpty()) {
                                technicianFeedback = or.getTechnicianFeedback();
                            }
                            if (or.getPicturePath() != null && !or.getPicturePath().isEmpty()) {
                                picturePath = or.getPicturePath();
                            }
                        }
                    }
                }
                if (userFeedback != null) {
                    dataRate += 10;
                }
                if (technicianFeedback != null) {
                    dataRate += 10;
                }
                if (picturePath != null) {
                    dataRate += 40;
                }
            }
        }
        return dataRate;
    }

    /**
     * 聚合订单聚合
     *
     * @param orderManage
     * @return
     */
    private OrderManage aggregateOrderManage(OrderManage orderManage) {
        Integer id = orderManage.getId();
        //1、订单详情
        List<OrderServe> orderServeList = orderServeMapper.selectList(new LambdaQueryWrapper<OrderServe>().eq(OrderServe::getOrderId, id));
        orderManage.setListOrderServer(orderServeList);

        //2、订单关联的卡券
        List<CouponCustomerRelevance> couponCustomerRelevanceList = couponCustomerRelevanceService.list(
                new LambdaQueryWrapper<CouponCustomerRelevance>().eq(CouponCustomerRelevance::getOrderId, id)
        );
        orderManage.setCouponCustomerRelevanceList(couponCustomerRelevanceList);

        //3、订单关联的次卡
        List<TimesCardUsedRecord> timesCardUsedRecordList = timesCardUsedRecordService.list(
                new LambdaQueryWrapper<TimesCardUsedRecord>().eq(TimesCardUsedRecord::getOrderId, id)
        );
        orderManage.setListTimesCardRecord(timesCardUsedRecordList);

        //4、订单服务关联的美甲师列表
        orderManage.getListOrderServer()
                .forEach(orderServe -> {
                    List<String> ids = Lists.newArrayList(orderServe.getTechnicianId().split(","));
                    orderServe.setListTechnicianManage(ids
                            .stream()
                            .map(Integer::valueOf)
                            .map(storeTechnicianMapper::selectById)
                            .collect(Collectors.toList()));
                });

        //订单服务实际时长计算
        orderManage.getListOrderServer().forEach(orderServe -> {
            if (orderServe.getEndTime() != null && orderServe.getStartTime() != null) {
                orderServe.setActualServeDuration((int) (orderServe.getEndTime().getTime() -
                        orderServe.getStartTime().getTime()) / 1000 / 60);
            }

        });

        //5、订单关联的预约
        ScheduleManage scheduleManage = scheduleManageMapper.selectById(orderManage.getScheduledId());
        orderManage.setScheduleManage(scheduleManage);

        //6、下单用户
        Customer customer = customerService.getById(orderManage.getOrderUser());
        orderManage.setCustomer(customer);
        //7、支付用户
        Customer payCustomer = customerService.getById(orderManage.getPayUser());
        orderManage.setPayCustomer(payCustomer);
        return orderManage;
    }
}




