package com.gogirl.shared.order.purchase.query.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class PurchaseOrderDTO {

    private Integer id;

    @ApiModelProperty(value = "商品sku编号")
    private String sku;

    @ApiModelProperty(value = "没有关联sku前,店员填的商品名字")
    private String orderName;

    @ApiModelProperty(value = "订单创建人")
    private Integer creater;

    private String createrName;

    @ApiModelProperty(value = "该订单的采购单价")
    private Double price;

    @ApiModelProperty(value = "采购数量")
    private Integer quantity;

    @ApiModelProperty(value = "发起采购的店铺")
    private Integer createDepartmentId;

    @ApiModelProperty(value = "采购寄到哪个店铺id")
    private Integer departmentId;

    private String departmentName;

    @ApiModelProperty(value = "-1.作废 1.待采购;2.采购中;3.待入库;4.待出库;5.待收货;6.已完成;")
    private Integer status;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty(value = "待采购时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date waitPurchaseTime;

    @ApiModelProperty(value = "确认采购时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date purchaseTime;

    @ApiModelProperty(value = "入库时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date inStoreTime;

    @ApiModelProperty(value = "出库时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date outStoreTime;

    @ApiModelProperty(value = "收货时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date receiveTime;

    @ApiModelProperty(value = "收货人id")
    private Integer receiver;

    @ApiModelProperty(value = "创建采购时的备注")
    private String createRemark;

    @ApiModelProperty(value = "收货时备注")
    private String receiveRemark;

    @ApiModelProperty("图片路径,用逗号隔开多张图片")
    private String skuPicturePath;

    @ApiModelProperty("商品名字")
    private String skuName;

    @ApiModelProperty("商品类型")
    private String skuTypeName;

    @ApiModelProperty(value = "1.入库;2.出库")
    private Integer stockType;

    private Integer stockNum;

    private BigDecimal shopPrice;

}
