package com.gogirl.interfaces.product.serve;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.application.product.serve.BaseProduceService;
import com.gogirl.domain.product.serve.BaseProduce;
import com.gogirl.domain.product.serve.BaseServe;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.dto.QueryProduceDetailRespDTO;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.util.SessionUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.stream.Collectors;


@Api(tags = {"预约服务款式接口"}, value = "预约服务款式接口")
@RestController
@AllArgsConstructor
public class ProduceController {

    private final BaseProduceService baseProduceService;


    @GetMapping("/customer/serve/no_queryProducePage")
    @ApiOperation(value = "款式列表")
    public JsonResult<IPage<BaseProduce>> queryProducePage(@RequestParam String token,
                                                           @RequestParam(required = false) Integer labelId,
                                                           @RequestParam(required = false) Integer serveTypeId,
                                                           @RequestParam(required = false) Integer colorSystemId,
                                                           @RequestParam(required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(required = false, defaultValue = "10") Integer pageSize) {
        IPage<BaseProduce> page = baseProduceService.queryProducePage(labelId, serveTypeId, colorSystemId, pageNum, pageSize);
        return JsonResult.success(page);
    }


    @ApiOperation(value = "查询款式详情", notes = "查询款式详情")
    @GetMapping("/customer/produce/queryProduceDetail")
    public JsonResult<BaseProduce> queryProduceDetail(Integer id) {
        BaseProduce baseProduce = baseProduceService.getProduceForDetail(id);
        return JsonResult.success(baseProduce);
    }

    @ApiOperation(value = "查询款式详情")
    @GetMapping("/customer/produce/queryProduceDetail2")
    public JsonResult<QueryProduceDetailRespDTO> queryProduceDetail2(@RequestParam Integer id) {


        BaseProduce produce = baseProduceService.getProduceForDetail(id);
        QueryProduceDetailRespDTO data = new QueryProduceDetailRespDTO();

        //款式
        data.setProduce(produce);
        //服务
        data.setServe(produce.getServe());
        return JsonResult.success(data);
    }


    @PostMapping("/customer/serve/praiseProduce")
    @ApiOperation(value = "款式点赞和取消点赞", notes = "款式点赞")
    public JsonResult<Void> praiseProduce(@RequestHeader String token,
                                          @RequestParam Integer produceId) {
        baseProduceService.praiseProduce(produceId);
        return JsonResult.success();
    }


}
