package com.gogirl.infrastructure.common.exception;


import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.service.mail.MailService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;

/**
 * 统一异常处理器
 *
 * @author robbendev
 */
@ControllerAdvice
@ResponseBody
@Slf4j
public class RRExceptionHandler {

    @Value("${spring.profiles.active}")
    private String profile;

    @Resource
    MailService mailService;

    /**
     * 自定义异常
     */
    @ExceptionHandler(RRException.class)
    public JsonResult<String> handleRRException(HttpServletRequest request,
                                                RRException e) {
        JsonResult<String> result = new JsonResult<>();
        result.setSuccess(false);
        result.setCode(e.getCode());
        result.setMessage(e.getMessage());

        if (e.getCode() == 500 && e.getMessage().equals("业务异常")) {
            log.error(e.getMessage(), e);
        } else {
            log.error(e.getMessage());
        }
        return result;
    }

    /**
     * 未捕获异常
     */
    @ExceptionHandler(Exception.class)
    public JsonResult<String> handleException(HttpServletRequest request,
                                              Exception e) {
        JsonResult<String> result = new JsonResult<>();
        result.setSuccess(false);
        result.setCode(500);
        result.setMessage(e.getMessage());
        this.log(e, request);

        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);

        //发送邮件
        mailService.sendSimpleMail("robbendev@qq.com", profile + "异常", sw.toString());

        return result;
    }


    private void log(Exception ex, HttpServletRequest request) {
        log.error("************************异常开始*******************************");
        log.error("请求地址：" + request.getRequestURL());
        Enumeration<String> enumeration = request.getParameterNames();
        log.error("请求参数");
        while (enumeration.hasMoreElements()) {
            String name = enumeration.nextElement();
            log.error(name + "---" + request.getParameter(name));
        }

        if (ex instanceof RRException) {
            if (((RRException) ex).getCode() == 500 && ex.getMessage().equals("业务异常")) {
                this.logStackTrace(ex);
            } else {
                log.error(ex.getMessage());
            }
        } else {
            this.logStackTrace(ex);
        }
        log.error("************************异常结束*******************************");
    }


    private void logStackTrace(Exception ex) {
        for (StackTraceElement stackTraceElement : ex.getStackTrace()) {
            log.error(stackTraceElement.toString());
        }
    }

}
