package com.gogirl.application.dashboard.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.application.dashboard.DashboardService;
import com.gogirl.application.store.store.StoreManageService;
import com.gogirl.domain.store.store.StoreManage;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.common.util.StringUtils;
import com.gogirl.infrastructure.feign.AdminFeign;
import com.gogirl.shared.admin.AdminPage;
import com.gogirl.shared.admin.dashboard.req.*;
import com.gogirl.shared.admin.dashboard.resp.GetStoreTrendApiResp;
import com.gogirl.shared.admin.techcnian.AchievementsPersonaResult;
import com.gogirl.shared.admin.techcnian.AchievementsPersonaResultPageApiRequest;
import com.gogirl.shared.admin.techcnian.AdminTechnicianScoreResp;
import com.gogirl.shared.admin.techcnian.GetTechnicianPageRequest;
import com.google.gson.reflect.TypeToken;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/8/31 9:14 上午
 */
@Service
public class DashboardServiceImpl implements DashboardService {
    @Resource
    AdminFeign adminFeign;
    @Resource
    StoreManageService storeManageService;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Resource
    private HttpServletRequest httpServletRequest;

    private final int expireTime = 5;

    private List<String> handleDateUtc(List<String> localDateTimes) {
        return localDateTimes
                .stream()
                .map(str -> LocalDateTime.parse(str, DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX")))
                .map(localDateTime -> localDateTime.withSecond(0)
                        .withMinute(localDateTime.getMinute() - localDateTime.getMinute() % expireTime))
                .map(LocalDateTime::toString)
                .collect(Collectors.toList());
    }

    @Override
    public GetStoreTrendApiResp getStoreTrendApi(GetStoreTrendApiRequest request) {
        request.setDateUtc(this.handleDateUtc(request.getDateUtc()));
        String cacheResp = stringRedisTemplate.opsForValue().get(httpServletRequest.getRequestURI() + ":" + JsonUtilByFsJson.beanToJson(request));
        if (StringUtils.isNotEmpty(cacheResp)) {
            return JsonUtilByFsJson.jsonToBean(cacheResp, GetStoreTrendApiResp.class);
        }

        GetStoreTrendApiResp resp = adminFeign.getStoreTrendApi(request).getData();
        stringRedisTemplate.opsForValue().set(httpServletRequest.getRequestURI() + ":" + JsonUtilByFsJson.beanToJson(request), JsonUtilByFsJson.beanToJson(resp), expireTime, TimeUnit.MINUTES);
        return resp;
    }

    @Override
    public List<Map<String, Object>> getStoreListApi(GetStoreListApiRequest request) {
        request.setDateUtc(this.handleDateUtc(request.getDateUtc()));
        Type type = new TypeToken<List<Map<String, Object>>>() {
        }.getType();

        String cacheResp = stringRedisTemplate.opsForValue().get(httpServletRequest.getRequestURI() + ":" + JsonUtilByFsJson.beanToJson(request));
        if (StringUtils.isNotEmpty(cacheResp)) {
            return JSON.parseObject(cacheResp, type);
        }

        List<Map<String, Object>> resp = adminFeign.getStoreListApi(request).getData();
        stringRedisTemplate.opsForValue().set(httpServletRequest.getRequestURI() + ":" + JsonUtilByFsJson.beanToJson(request), JsonUtilByFsJson.beanToJson(resp), expireTime, TimeUnit.MINUTES);
        return resp;
    }

    @Override
    public Map<String, Object> preStorageSumApi(PreStorageSumApiRequest request) {
        request.setDateUtc(this.handleDateUtc(request.getDateUtc()));
        Type type = new TypeToken<Map<String, Object>>() {
        }.getType();

        String cacheResp = stringRedisTemplate.opsForValue().get(httpServletRequest.getRequestURI() + ":" + JsonUtilByFsJson.beanToJson(request));
        if (StringUtils.isNotEmpty(cacheResp)) {
            return JSON.parseObject(cacheResp, type);
        }

        Map<String, Object> resp = adminFeign.preStorageSumApi(request).getData();
        stringRedisTemplate.opsForValue().set(httpServletRequest.getRequestURI() + ":" + JsonUtilByFsJson.beanToJson(request), JsonUtilByFsJson.beanToJson(resp), expireTime, TimeUnit.MINUTES);
        return resp;

    }

    @Override
    public Map<String, Object> revenueSumByTypeApi(RevenueSumByTypeApiRequest request) {

        request.setDateUtc(this.handleDateUtc(request.getDateUtc()));
        Type type = new TypeToken<Map<String, Object>>() {
        }.getType();

        String cacheResp = stringRedisTemplate.opsForValue().get(httpServletRequest.getRequestURI() + ":" + JsonUtilByFsJson.beanToJson(request));
        if (StringUtils.isNotEmpty(cacheResp)) {
            return JSON.parseObject(cacheResp, type);
        }

        Map<String, Object> resp = adminFeign.revenueSumByTypeApi(request).getData();
        stringRedisTemplate.opsForValue().set(httpServletRequest.getRequestURI() + ":" + JsonUtilByFsJson.beanToJson(request), JsonUtilByFsJson.beanToJson(resp), expireTime, TimeUnit.MINUTES);
        return resp;


    }

    @Override
    public List<Map<String, Object>> revenueTypeListApi(RevenueTypeListRequest request) {
        request.setDateUtc(this.handleDateUtc(request.getDateUtc()));
        Type type = new TypeToken<List<Map<String, Object>>>() {
        }.getType();

        String cacheResp = stringRedisTemplate.opsForValue().get(httpServletRequest.getRequestURI() + ":" + JsonUtilByFsJson.beanToJson(request));
        if (StringUtils.isNotEmpty(cacheResp)) {
            return JSON.parseObject(cacheResp, type);
        }

        List<Map<String, Object>> resp = adminFeign.revenueTypeListApi(request).getData();
        stringRedisTemplate.opsForValue().set(httpServletRequest.getRequestURI() + ":" + JsonUtilByFsJson.beanToJson(request), JsonUtilByFsJson.beanToJson(resp), expireTime, TimeUnit.MINUTES);
        return resp;
    }

    @Override
    public List<Map<String, Object>> revenueSumApi(RevenueSumApiRequest request) {
        request.setDateUtc(this.handleDateUtc(request.getDateUtc()));
        Type type = new TypeToken<List<Map<String, Object>>>() {
        }.getType();
        List<Map<String, Object>> resp;

        String cacheResp = stringRedisTemplate.opsForValue().get(httpServletRequest.getRequestURI() + ":" + JsonUtilByFsJson.beanToJson(request));
        if (StringUtils.isNotEmpty(cacheResp)) {
            return JSON.parseObject(cacheResp, type);
        }

        resp = adminFeign.revenueSumApi(request).getData();
        resp.forEach(stringObjectMap -> {
            String storeName = String.valueOf(stringObjectMap.get("store_name"));
            StoreManage storeManage = storeManageService.getOne(new LambdaQueryWrapper<StoreManage>()
                    .eq(StoreManage::getName, storeName));
            stringObjectMap.put("departmentId", storeManage == null ? 0 : storeManage.getId());
        });
        stringRedisTemplate.opsForValue().set(httpServletRequest.getRequestURI() + ":" + JsonUtilByFsJson.beanToJson(request), JsonUtilByFsJson.beanToJson(resp), expireTime, TimeUnit.MINUTES);
        return resp;
    }

    @Override
    public AdminPage<AdminTechnicianScoreResp> getTechnicianPage(GetTechnicianPageRequest request) {
        request.setDate_utc(this.handleDateUtc(request.getDate_utc()));
        Type type = new TypeToken<AdminPage<AdminTechnicianScoreResp>>() {
        }.getType();

        String cacheResp = stringRedisTemplate.opsForValue().get(httpServletRequest.getRequestURI() + ":" + JsonUtilByFsJson.beanToJson(request));
        if (StringUtils.isNotEmpty(cacheResp)) {
            return JSON.parseObject(cacheResp, type);
        }

        AdminPage<AdminTechnicianScoreResp> resp = adminFeign.getTechnicianPage(request).getData();
        stringRedisTemplate.opsForValue().set(httpServletRequest.getRequestURI() + ":" + JsonUtilByFsJson.beanToJson(request), JsonUtilByFsJson.beanToJson(resp), expireTime, TimeUnit.MINUTES);
        return resp;
    }

    @Override
    public AdminPage<AchievementsPersonaResult> achievementsPersonaResultPageApi(AchievementsPersonaResultPageApiRequest request) {

        Type type = new TypeToken<AdminPage<AchievementsPersonaResult>>() {
        }.getType();

        String cacheResp = stringRedisTemplate.opsForValue().get(httpServletRequest.getRequestURI() + ":" + JsonUtilByFsJson.beanToJson(request));
        if (StringUtils.isNotEmpty(cacheResp)) {
            return JSON.parseObject(cacheResp, type);
        }

        AdminPage<AchievementsPersonaResult> resp = adminFeign.achievementsPersonaResultPageApi(request).getData();
        stringRedisTemplate.opsForValue().set(httpServletRequest.getRequestURI() + ":" + JsonUtilByFsJson.beanToJson(request), JsonUtilByFsJson.beanToJson(resp), expireTime, TimeUnit.MINUTES);
        return resp;

    }

    @Override
    public List<Map<String, Object>> revenueServiceListApi(RevenueServiceListApiRequest request) {
        request.setDateUtc(this.handleDateUtc(request.getDateUtc()));

        Type type = new TypeToken<List<Map<String, Object>>>() {
        }.getType();

        String cacheResp = stringRedisTemplate.opsForValue().get(httpServletRequest.getRequestURI() + ":" + JsonUtilByFsJson.beanToJson(request));
        if (StringUtils.isNotEmpty(cacheResp)) {
            return JSON.parseObject(cacheResp, type);
        }

        List<Map<String, Object>> resp = adminFeign.revenueServiceListApi(request).getData();

        stringRedisTemplate.opsForValue().set(httpServletRequest.getRequestURI() + ":" + JsonUtilByFsJson.beanToJson(request), JsonUtilByFsJson.beanToJson(resp), expireTime, TimeUnit.MINUTES);
        return resp;
    }
}
