package com.gogirl.application.store.store;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.gogirl.domain.store.store.StoreManage;

import java.util.List;


/**
 * 店铺服务
 */
public interface StoreManageService extends IService<StoreManage> {

    /**
     * 查询店铺列表
     *
     * @param param 查询参数
     * @return 店铺列表
     */
    IPage<StoreManage> listShopManageForPage(IPage<StoreManage> page, StoreManage param);

    /**
     * 获取美甲师绑定的店铺
     *
     * @return
     */
    List<StoreManage> getTechnicianShopList();


    /**
     * 查询店铺详情
     *
     * @param id
     * @param longitude
     * @param latitude
     * @return
     */
    StoreManage getShopManageForDetail(Integer id, String longitude, String latitude);
}
