package com.gogirl.shared.order;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Data
public class TreeProgram implements Serializable {

    /**
     * 节点的美甲师
     */
    StoreTechnicianPeriod storeTechnicianDTO;

    /**
     * 节点的服务
     */
    ScheduleServeQuery scheduleServeQuery;

    /**
     * 子节点
     */
    List<TreeProgram> childList = Lists.newArrayList();

    /**
     * 根节点到该节点的所有节点
     */
    @JsonIgnore
    List<TreeProgram> path = Lists.newArrayList();

    /**
     * 父亲节点
     */
    @JsonIgnore
    TreeProgram parent;

    public TreeProgram() {
    }

    /**
     * 节点构造函数
     *
     * @param storeTechnicianDTO 节点美甲师
     * @param scheduleServeQuery 节点服务
     * @param parent             父节点
     */
    public TreeProgram(StoreTechnicianPeriod storeTechnicianDTO, ScheduleServeQuery scheduleServeQuery, TreeProgram parent) {


        this.storeTechnicianDTO = storeTechnicianDTO;
        this.scheduleServeQuery = scheduleServeQuery;
        this.parent = parent;
        List<TreeProgram> path = new ArrayList<>(parent.getPath());
        path.add(this);
        this.path = path;
        this.childList = Collections.emptyList();
    }

    public static TreeProgram root() {
        return new TreeProgram();
    }

    /**
     * 移除子节点
     *
     * @param treeProgram 子节点
     */
    public void remove(TreeProgram treeProgram) {
        childList.remove(treeProgram);
    }

    /**
     * 移除自己
     */
    public void removeSelf() {
        if (parent != null) {
            parent.remove(this);
        }
    }

    /**
     * 判断是否所有子节点为空
     *
     * @return
     */
    public boolean childNull() {
        return CollectionUtils.isEmpty(childList);
    }

    public boolean sameTechnicianServeAs(TreeProgram treeProgram) {
        return this.getStoreTechnicianDTO().getTechnicianId().equals(treeProgram.getStoreTechnicianDTO().getTechnicianId())
                && this.getScheduleServeQuery().getServeId().equals(treeProgram.getScheduleServeQuery().getServeId());
    }

    public boolean isSubTree(TreeProgram treeProgram) {
        if (treeProgram == null) {
            return true;
        }
        boolean bool = this.isSameNode(treeProgram);
        if (!bool) {
            return false;
        } else {
            TreeProgram subPath = this.getChildList().stream().findAny().orElseThrow(NullPointerException::new);
            List<TreeProgram> targetTreeList = treeProgram.getChildList();
            TreeProgram targetTree = targetTreeList.stream().filter(val -> val.isSameNode(subPath)).findAny().orElse(null);
            if (targetTree == null) {
                return false;
            }
            return subPath.isSubTree(targetTree);
        }
    }

    public boolean isSameNode(TreeProgram treeProgram) {

        /**/
        boolean sameServe = this.getScheduleServeQuery().getLengthTimeForEndTime()
                .equals(treeProgram.getScheduleServeQuery().getLengthTimeForEndTime())
                && this.getScheduleServeQuery().getServeId().equals(treeProgram.getScheduleServeQuery().getServeId())
                && this.getScheduleServeQuery().getProduceId().equals(treeProgram.getScheduleServeQuery().getProduceId())
                && this.getScheduleServeQuery().getPeriod().equals(treeProgram.getScheduleServeQuery().getPeriod());

        /**/
        boolean sameTech = this.getStoreTechnicianDTO().getTechnicianId().equals(treeProgram.getStoreTechnicianDTO().getTechnicianId());

        /**/
        return sameServe && sameTech;
    }
}

