package com.gogirl.domain.order.market;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020-03-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "CouponOrder对象", description = "")
public class CouponOrder implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
    private final Integer id;

    @ApiModelProperty(value = "卡券订单编号")
    private Integer couponOrderNo;

    @ApiModelProperty(value = "用户id")
    private Integer customerId;

    @ApiModelProperty(value = "卡券id")
    private Integer couponCustomerRelevanceId;

    @ApiModelProperty(value = "卡券名称")
    private String couponName;

    @ApiModelProperty(value = "卡券折扣金额")
    private BigDecimal discountAmount;

    @ApiModelProperty(value = "到达多少金额可以使用")
    private BigDecimal reachingAmount;

    @ApiModelProperty(value = "订单支付金额")
    private BigDecimal payAmount;

    private LocalDateTime createTime;

    @ApiModelProperty(value = "1-已完成")
    private Integer status;


}
