package com.gogirl.interfaces.product.serve;


import com.gogirl.application.product.serve.ITechniqueSkuService;
import com.gogirl.domain.product.serve.TechniqueSku;
import com.gogirl.infrastructure.common.base.JsonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 技法sku 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-05-27
 */
@Api(tags = "款式技法接口")
@RestController
public class TechniqueSkuController {
    @Resource
    ITechniqueSkuService techniqueSkuService;

    @ApiOperation("查询所有款式技法")
    @GetMapping("/technician/techniqueSku/queryAll")
    public JsonResult<List<TechniqueSku>> queryAll() {
        List<TechniqueSku> techniqueSkuList = techniqueSkuService.queryAll();
        return JsonResult.success(techniqueSkuList);
    }


    @ApiOperation("查询所有款式技法分组")
    @GetMapping("/technician/techniqueSku/queryMap")
    public JsonResult<Map<String, List<TechniqueSku>>> queryMap() {
        List<TechniqueSku> techniqueSkuList = techniqueSkuService.queryAll();
        return JsonResult.success(techniqueSkuList.stream().collect(Collectors.groupingBy(TechniqueSku::getTechniqueCategoryName)));
    }
}
