package com.gogirl.application.order.purchase.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.application.order.purchase.PurchaseOrderQryService;
import com.gogirl.domain.order.purchase.PurchaseOrder;
import com.gogirl.infrastructure.mapper.order.purchase.PurchaseOrderMapper;
import com.gogirl.shared.order.PurchaseOrderPageQuery;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

@Service
@AllArgsConstructor
public class PurchaseOrderQryServiceImpl implements PurchaseOrderQryService {

    private final PurchaseOrderMapper purchaseOrderMapper;

    @Override
    public IPage<PurchaseOrder> queryPagePurchaseOrder(PurchaseOrderPageQuery qry) {


        LambdaQueryWrapper<PurchaseOrder> wrapper = new LambdaQueryWrapper<>();
        if (qry.getStatus().equals(1)) {
            wrapper.in(PurchaseOrder::getStatus, Lists.newArrayList(
                    PurchaseOrder.STATUS_WAIT_PURCHASE,
                    PurchaseOrder.STATUS_IN_PURCHASING,
                    PurchaseOrder.STATUS_WAIT_IN_STOCK_,
                    PurchaseOrder.STATUS_WAIT_OUT_STOCK));
        }
        //已完成
        if (qry.getStatus().equals(2)) {
            wrapper.eq(PurchaseOrder::getStatus, PurchaseOrder.STATUS_UN_RECEIVED);
        }

        //待收货
        if (qry.getStatus().equals(3)) {
            wrapper.eq(PurchaseOrder::getStatus, PurchaseOrder.STATUS_FINISHED);
        }
        if (qry.getDepartmentId() != null) {
            wrapper.eq(PurchaseOrder::getDepartmentId, qry.getDepartmentId());
        }
        wrapper.orderByDesc(PurchaseOrder::getCreateTime);
        IPage<PurchaseOrder> page = new Page<>(qry.getPageNum(), qry.getPageSize());

        page = purchaseOrderMapper.selectPage(page, wrapper);
        return page;
    }
}
