package com.gogirl;

import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.gogirl.application.market.coupon.CouponCustomerRelevanceService;
import com.gogirl.application.market.coupon.CouponService;
import com.gogirl.application.market.coupon.MarketService;
import com.gogirl.application.market.timescard.TimesCardCustomerRelevanceService;
import com.gogirl.application.market.timescard.TimesCardUsedRecordService;
import com.gogirl.application.order.serve.OrderManageService;
import com.gogirl.application.store.store.StoreTechnicianService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.market.coupon.CouponCustomerRelevance;
import com.gogirl.domain.market.discount.DiscountConfig;
import com.gogirl.domain.order.pay.OrderPay;
import com.gogirl.domain.order.serve.MultiPaymentType;
import com.gogirl.domain.order.serve.OrderManage;
import com.gogirl.domain.order.serve.OrderServe;
import com.gogirl.domain.product.purchase.PurchaseStock;
import com.gogirl.domain.product.purchase.PurchaseStockRecord;
import com.gogirl.domain.store.complaint.ComplaintDetailed;
import com.gogirl.domain.store.complaint.ComplaintDetailedTechnician;
import com.gogirl.domain.store.complaint.ComplaintMain;
import com.gogirl.domain.store.oa.OvertimeRecord;
import com.gogirl.domain.store.oa.TakeLeaveEvent;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.domain.user.customer.Customer;
import com.gogirl.domain.user.customer.CustomerBalance;
import com.gogirl.domain.user.customer.CustomerBalanceRecord;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.domain.xcx.TimeNode;
import com.gogirl.domain.xcx.WeekConfig;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.excel.ExcelListener;
import com.gogirl.infrastructure.excel.MallProductExcelListener;
import com.gogirl.infrastructure.mapper.market.coupon.CouponCustomerRelevanceMapper;
import com.gogirl.infrastructure.mapper.market.discount.DiscountConfigMapper;
import com.gogirl.infrastructure.mapper.market.discount.LeisureDiscountConfigWeekMapper;
import com.gogirl.infrastructure.mapper.market.timescard.TimesCardCustomerRelevanceMapper;
import com.gogirl.infrastructure.mapper.order.pay.OrderPayMapper;
import com.gogirl.infrastructure.mapper.order.serve.OrderManageMapper;
import com.gogirl.infrastructure.mapper.order.serve.OrderServeMapper;
import com.gogirl.infrastructure.mapper.product.mall.MallProductMapper;
import com.gogirl.infrastructure.mapper.product.purchase.PurchaseSkuMapper;
import com.gogirl.infrastructure.mapper.product.purchase.PurchaseStockMapper;
import com.gogirl.infrastructure.mapper.product.purchase.PurchaseStockRecordMapper;
import com.gogirl.infrastructure.mapper.store.complaint.ComplaintDetailedMapper;
import com.gogirl.infrastructure.mapper.store.complaint.ComplaintDetailedTechnicianMapper;
import com.gogirl.infrastructure.mapper.store.complaint.ComplaintMainMapper;
import com.gogirl.infrastructure.mapper.store.oa.OvertimeRecordMapper;
import com.gogirl.infrastructure.mapper.store.oa.TakeLeaveEventMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerBalanceMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerBalanceRecordMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerMapper;
import com.gogirl.infrastructure.mapper.xcx.TimeNodeMapper;
import com.gogirl.infrastructure.mapper.xcx.WeekConfigMapper;
import com.gogirl.infrastructure.schedule.Schedule;
import com.gogirl.infrastructure.service.mail.MailService;
import com.gogirl.shared.product.excel.ImportMallProductExcel;
import com.gogirl.shared.product.excel.ImportPurchaseSkuExcel;
import lombok.extern.slf4j.Slf4j;
import org.assertj.core.util.Lists;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.Resource;
import java.io.File;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.*;
import java.util.stream.Collectors;

@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@EnableAsync
public class Test {

    @Resource
    private TimeNodeMapper timeNodeMapper;

    @org.junit.Test
    public void timeNode() throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        LocalTime localTime = LocalTime.of(0, 0);
        LocalTime localTime2 = LocalTime.of(23, 45);


        while (localTime.compareTo(localTime2) < 0) {
            TimeNode timeNode = new TimeNode();
            timeNode.setTimeNode(localTime);
            timeNodeMapper.insert(timeNode);
            localTime = localTime.plusMinutes(15);
        }
    }

    @Resource
    private LeisureDiscountConfigWeekMapper leisureDiscountConfigWeekMapper;
    @Resource
    private WeekConfigMapper weekConfigMapper;

    @org.junit.Test
    public void weekTest() throws ParseException {

        weekConfigMapper.delete(new LambdaQueryWrapper<>());

        LocalDate localDate = LocalDate.now();
        for (int i = 0; i < 7; i++) {
            WeekConfig weekConfig = new WeekConfig();
            weekConfig.setWeek(localDate.getDayOfWeek().getValue());
            weekConfig.setWeekStr(localDate.getDayOfWeek().toString());
            weekConfig.setWeekDate(localDate);
            weekConfigMapper.insert(weekConfig);
            localDate = localDate.plusDays(1);
        }
    }

    @Resource
    OrderPayMapper orderPayMapper;
    @Resource
    OrderManageMapper orderManageMapper;
    @Resource
    CouponCustomerRelevanceMapper couponCustomerRelevanceMapper;

    @org.junit.Test
    public void orderPay() {

        orderPayMapper.delete(new LambdaQueryWrapper<>());

        List<OrderManage> orderManageList = orderManageMapper.selectList(new LambdaQueryWrapper<OrderManage>()
                .gt(OrderManage::getFinishTime, "2020-01-01"));


        // order_pay 微信 = 1, 会员 = 2, 充值 = 4, pos机 = 5, 大众点评 = 7, 会员帮付 = 11, 次卡 =12
        //1#微信 2#会员 3#其他4#充值5#pos机6#现金7#大众点评8#微信扫码支付9#团购10#免单11#会员帮付12#余额抵扣微信支付13余额pos支付
        orderManageList.forEach(orderManage -> {
            if (orderManage.getPaymentType().equals(1)) {
                OrderPay orderPay = new OrderPay();
                orderPay.setAmount(orderManage.getTotalPaymentAmount());
                orderPay.setOrderId(orderManage.getId());
                orderPay.setType(1);
                orderPayMapper.insert(orderPay);
            }
            if (orderManage.getPaymentType().equals(2)) {
                OrderPay orderPay = new OrderPay();
                orderPay.setAmount(orderManage.getTotalPaymentAmount());
                orderPay.setOrderId(orderManage.getId());
                orderPay.setType(2);
                orderPayMapper.insert(orderPay);
            }
            if (orderManage.getPaymentType().equals(5)) {
                OrderPay orderPay = new OrderPay();
                orderPay.setAmount(orderManage.getTotalPaymentAmount());
                orderPay.setOrderId(orderManage.getId());
                orderPay.setType(5);
                orderPayMapper.insert(orderPay);
            }

            if (orderManage.getPaymentType().equals(12) || orderManage.getPaymentType().equals(13)) {

                try {
                    List<MultiPaymentType> multiPaymentTypeList = JsonUtilByFsJson.jsonToList(orderManage.getMultiplePaymentType(), MultiPaymentType.class);
                    multiPaymentTypeList.forEach(multiPaymentType -> {
                        if (multiPaymentType.getType().equals(1)) {
                            OrderPay orderPay = new OrderPay();
                            orderPay.setAmount(multiPaymentType.getPrice());
                            orderPay.setOrderId(orderManage.getId());
                            orderPay.setType(1);
                            orderPayMapper.insert(orderPay);
                        }
                        if (multiPaymentType.getType().equals(2)) {
                            OrderPay orderPay = new OrderPay();
                            orderPay.setAmount(multiPaymentType.getPrice());
                            orderPay.setOrderId(orderManage.getId());
                            orderPay.setType(2);
                            orderPayMapper.insert(orderPay);
                        }

                        if (multiPaymentType.getType().equals(5)) {
                            OrderPay orderPay = new OrderPay();
                            orderPay.setAmount(multiPaymentType.getPrice());
                            orderPay.setOrderId(orderManage.getId());
                            orderPay.setType(5);
                            orderPayMapper.insert(orderPay);
                        }
                    });
                } catch (Exception e) {
                    log.error("orderId:no multi :{}", orderManage.getId());
                }
            }
        });

        orderPayMapper.delete(new LambdaQueryWrapper<OrderPay>().eq(OrderPay::getAmount, 0));
    }


    @org.junit.Test
    public void customerPay() {

        List<CouponCustomerRelevance> couponCustomerRelevanceList = couponCustomerRelevanceMapper.selectByOrderTimes();

        couponCustomerRelevanceList.forEach(couponCustomerRelevance -> {
            if (couponCustomerRelevance.getSourceType().equals(1)) {
                OrderPay orderPay = new OrderPay();
                orderPay.setAmount(couponCustomerRelevance.getPayAmount());
                orderPay.setOrderId(couponCustomerRelevance.getOrderId());
                orderPay.setType(7);
                orderPayMapper.insert(orderPay);
            }
        });
    }

    @Resource
    RedisTemplate<String, String> redisTemplate;
    @Resource
    GogirlTokenService gogirlTokenService;
    @Resource
    CustomerMapper customerMapper;

    @org.junit.Test
    public void values() {
        Customer customer = customerMapper.selectById(20432);
        GogirlToken gogirlToken = GogirlToken.builder()
                .token(20432 + "_" + IdWorker.getIdStr().substring(6))
                .createTime(new Date())
                .openid(customer.getOpenid1())
                .customerId(20432)
                .build();
        gogirlTokenService.save(gogirlToken);
        System.out.println(gogirlToken.getToken());
    }

    @Resource
    ComplaintDetailedMapper complaintDetailedMapper;
    @Resource
    OrderServeMapper orderServeMapper;
    @Resource
    ComplaintMainMapper complaintMainMapper;
    @Resource
    ComplaintDetailedTechnicianMapper complaintDetailedTechnicianMapper;
    @Resource
    TimesCardCustomerRelevanceMapper timesCardCustomerRelevanceMapper;

    @org.junit.Test
    public void complain() {
        List<ComplaintDetailed> complaintDetailedList = complaintDetailedMapper.complainTest();

        complaintDetailedList.forEach(complaintDetailed -> {

            ComplaintMain complaintMain = complaintMainMapper.selectById(complaintDetailed.getMainId());
            List<Integer> technicianIds = orderServeMapper.selectList(new LambdaQueryWrapper<OrderServe>()
                    .eq(OrderServe::getOrderId, complaintMain.getOrderId()))
                    .stream()
                    .map(OrderServe::getTechnicianId)
                    .map(id -> Lists.newArrayList(id.split(",")))
                    .flatMap(List::stream)
                    .map(Integer::valueOf)
                    .collect(Collectors.toList());
            technicianIds.forEach(technicianId -> {
                ComplaintDetailedTechnician complaintDetailedTechnician = new ComplaintDetailedTechnician();
                complaintDetailedTechnician.setTechnicianId(technicianId);
                complaintDetailedTechnician.setComplaintDetailedId(complaintDetailed.getId());
                complaintDetailedTechnicianMapper.insert(complaintDetailedTechnician);
            });

        });
    }

    @Resource
    CouponCustomerRelevanceService couponCustomerRelevanceService;
    @Resource
    TimesCardUsedRecordService timesCardUsedRecordService;
    @Resource
    TimesCardCustomerRelevanceService timesCardCustomerRelevanceService;
    @Resource
    StoreTechnicianService storeTechnicianService;
    @Resource
    CustomerBalanceRecordMapper customerBalanceRecordMapper;

    @org.junit.Test
    public void setChargeReferees() {
        log.debug("每天晚上11:50定时设置当天服务的技师为推荐人** 任务开始");

        SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyy-MM-dd");

        String day = "2020-04-04";

        log.debug("设置推荐人:当天服务的技师为推荐人");
        Map<String, String> mapTechnicianManage = new HashMap<>();
        List<StoreTechnician> listTechnicianManage = storeTechnicianService.listTechnicianForPage(new StoreTechnician());

        //查出所有的技师,找到技师id和user_id
        for (StoreTechnician item : listTechnicianManage) {
            mapTechnicianManage.put(String.valueOf(item.getTechnicianId()), String.valueOf(item.getUserId()));
        }

        //找到当天的订单的推荐人
        List<CustomerBalanceRecord> list = customerBalanceRecordMapper.getXcxChargeRecord(day);

        //遍历设置推荐人
        for (CustomerBalanceRecord customerBalanceRecord : list) {

            //推荐人列表
            Map<String, String> map = new HashMap<>();
            //推荐人id
            StringBuilder referee_ids = new StringBuilder();
            //充值记录
            CustomerBalanceRecord cbrt = customerBalanceRecordMapper.selectById(customerBalanceRecord.getId());
            //每次都修改推荐人,且每晚都会设置推荐人
            if (customerBalanceRecord.getRefereeId() != null) {
                String[] arr = customerBalanceRecord.getRefereeId().split(",");
                //
                for (String s : arr) {
                    if (!map.containsKey(s)) {
                        map.put(s, s);
                        referee_ids.append(",").append(mapTechnicianManage.get(s));
                    }
                }
                //去掉首尾,
                if (referee_ids.toString().startsWith(",")) {
                    referee_ids = new StringBuilder(referee_ids.substring(1));
                }
                customerBalanceRecord.setRefereeId(referee_ids.toString());
            }
            //如果店铺id不为空
            if (cbrt != null && cbrt.getDepartmentId() != null) {
                customerBalanceRecord.setDepartmentId(cbrt.getDepartmentId());
            }
            if (customerBalanceRecord.getId() != null
                    && (customerBalanceRecord.getRefereeId() != null || customerBalanceRecord.getDepartmentId() != null)) {
                customerBalanceRecordMapper.updateById(customerBalanceRecord);
            }
        }
        log.debug("每天晚上11:50定时设置当天服务的技师为推荐人** 任务结束");
    }


    @Resource
    PurchaseStockMapper purchaseStockMapper;
    @Resource
    PurchaseStockRecordMapper purchaseStockRecordMapper;

    @org.junit.Test
    public void stockTest() {
        List<PurchaseStock> purchaseStockList = purchaseStockMapper.selectList(
                new LambdaQueryWrapper<PurchaseStock>()
                        .eq(PurchaseStock::getDepartmentId, 0)
                        .ge(PurchaseStock::getSku, "MJJ00006")
                        .le(PurchaseStock::getSku, "MJJ00233")
                        .gt(PurchaseStock::getNum, 0));

        purchaseStockList.forEach(purchaseStock -> {
            purchaseStock.setNum(purchaseStock.getNum() - 1);
            purchaseStockMapper.updateById(purchaseStock);

            PurchaseStockRecord purchaseStockRecord = PurchaseStockRecord.builder()
                    .stockId(purchaseStock.getId())
                    .stockQuantity(purchaseStock.getNum())
                    .departmentId(0)
                    .quantity(1)
                    .remarks("excel批量出库")
                    .sku(purchaseStock.getSku())
                    .time(LocalDateTime.now())
                    .type(2)
                    .typeRemarks("excel批量出库")
                    .build();
            purchaseStockRecordMapper.insert(purchaseStockRecord);

        });
    }

    @Resource
    CustomerBalanceMapper customerBalanceMapper;
    @Resource
    DiscountConfigMapper discountConfigMapper;
    @Resource
    CouponService couponService;


    @org.junit.Test
    public void notifyChargeOrder() {
        int totalFee = 100000;
        String openid = "ot_nm5VbDqBbl6trcHKL0LM_AiNA";

        Customer customer = customerMapper.selectOne(new LambdaQueryWrapper<Customer>().eq(Customer::getOpenid1, openid));

        CustomerBalance customerBalance = customerBalanceMapper.selectOne(
                new LambdaQueryWrapper<CustomerBalance>().eq(CustomerBalance::getCustomerId, customer.getId()));

        DiscountConfig discountConfig = discountConfigMapper.selectList(new LambdaQueryWrapper<>())
                .stream().filter(config -> config.getChargeAmount() <= totalFee)
                .max(Comparator.comparing(DiscountConfig::getChargeAmount)).orElseThrow(NullPointerException::new);

        couponService.sendCoupon(discountConfig.getCouponId(), customer.getId());


        //首次充值
        if (customerBalance == null || customerBalance.getBalance() == 0) {
            if (customerBalance == null) {
                customerBalance = CustomerBalance.builder()
                        //充值金额+赠送金额
                        .balance(totalFee)
                        .customerId(customer.getId())
                        .currentDiscount(1.00)
                        .discountRate(0.00)
                        .firstChargeTime(new Date())
                        .level(discountConfig.getLevel())
                        //赠送金额
                        .totalBestow(0)
                        //总充值金额
                        .totalCharge(totalFee)
                        .totalExpenditure(0)
                        .updateTime(new Date())
                        .version(5)
                        .build();
            } else {
                customerBalance.setBalance(totalFee);
                customerBalance.setCurrentDiscount(1.00);
                customerBalance.setDiscountRate(0.00);
                customerBalance.setFirstChargeTime(new Date());
                customerBalance.setLevel(discountConfig.getLevel());
                customerBalance.setTotalBestow(0);
                customerBalance.setTotalCharge(totalFee);
                customerBalance.setTotalExpenditure(0);
                customerBalance.setUpdateTime(new Date());
                customerBalance.setVersion(5);
            }


            //会员卡不存在
            if (customerBalance.getId() == null) {
                customerBalanceMapper.insert(customerBalance);
            }

            //会员卡存在
            else {
                customerBalanceMapper.updateById(customerBalance);
            }

            CustomerBalanceRecord customerBalanceRecord = CustomerBalanceRecord.builder()
                    .time(new Date())
                    .orderId(IdWorker.getIdStr())
                    .orderAmount(totalFee)
                    .discount(1.00)
                    .currentBalance(customerBalance.getBalance())
                    .bestowAmount(0)
                    //首次充值
                    .type(2)
                    .customerId(customer.getId())
                    //微信支付
                    .source(1)
                    .build();
            customerBalanceRecordMapper.insert(customerBalanceRecord);
        }

        //充值
        else {
            //更新用户余额
            customerBalance.setBalance(customerBalance.getBalance() + totalFee);
            customerBalance.setLevel(discountConfig.getLevel());
            customerBalance.setUpdateTime(new Date());

            //总送
            customerBalance.setTotalCharge(customerBalance.getTotalCharge() + totalFee);
            customerBalanceMapper.updateById(customerBalance);

            //
            CustomerBalanceRecord customerBalanceRecord = CustomerBalanceRecord.builder()
                    .time(new Date())
                    .orderId(IdWorker.getIdStr())
                    .orderAmount(totalFee)
                    .discount(1.00)
                    .currentBalance(customerBalance.getBalance())
                    .bestowAmount(0)
                    //首次充值
                    .type(1)
                    .customerId(customer.getId())
                    //微信支付
                    .source(1)
                    .build();
            customerBalanceRecordMapper.insert(customerBalanceRecord);
        }
    }

    @Resource
    MailService mailService;

    @org.junit.Test
    public void testMail() {
        mailService.sendSimpleMail("robbendev@qq.com", "pre", "test");
    }


    @Resource
    Schedule schedule;

    @org.junit.Test
    public void career() {
        schedule.syncTechnicianCareer();
    }

    @org.junit.Test
    public void couponCustomerRelevanceError() {
        List<CouponCustomerRelevance> couponCustomerRelevanceList = couponCustomerRelevanceMapper.couponCustomerRelevanceError();
        couponCustomerRelevanceList.forEach(couponCustomerRelevance -> {
            couponCustomerRelevance.setValidEndTime(new Date(couponCustomerRelevance.getValidStartTime().getTime() + 30 * 24 * 60 * 60 * 1000L));
            if (couponCustomerRelevance.isValid()) {
                couponCustomerRelevance.setState(1);
            }
            couponCustomerRelevanceMapper.updateById(couponCustomerRelevance);
        });
    }

    @org.junit.Test
    public void testReferId() {


        log.debug("每天晚上11:50定时设置当天服务的技师为推荐人** 任务开始");

        SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyy-MM-dd");

        String day = yyyyMMdd.format(new Date());

        log.debug("设置推荐人:当天服务的技师为推荐人");
        Map<String, String> mapTechnicianManage = new HashMap<>();
        List<StoreTechnician> listTechnicianManage = storeTechnicianService.listTechnicianForPage(new StoreTechnician());

        //查出所有的技师,找到技师id和user_id
        for (StoreTechnician item : listTechnicianManage) {
            mapTechnicianManage.put(String.valueOf(item.getTechnicianId()), String.valueOf(item.getUserId()));
        }


        CustomerBalanceRecord customerBalanceRecord = new CustomerBalanceRecord();
        customerBalanceRecord.setRefereeId("92,92,108,108,108,108");

        //推荐人列表
        Map<String, String> map = new HashMap<>();
        //推荐人id
        StringBuilder referee_ids = new StringBuilder();
        //充值记录
        //每次都修改推荐人,且每晚都会设置推荐人
        if (customerBalanceRecord.getRefereeId() != null) {
            String[] arr = customerBalanceRecord.getRefereeId().split(",");
            //
            for (String s : arr) {
                if (!map.containsKey(s)) {
                    map.put(s, s);
                    referee_ids.append(",").append(mapTechnicianManage.get(s));
                }
            }
            //去掉首尾,
            if (referee_ids.toString().startsWith(",")) {
                referee_ids = new StringBuilder(referee_ids.substring(1));
            }
            customerBalanceRecord.setRefereeId(referee_ids.toString());
        }

        System.out.println(customerBalanceRecord.getRefereeId());
    }


    @Resource
    MarketService marketService;

    @org.junit.Test
    public void achievementReCalc() {
        List<CouponCustomerRelevance> couponCustomerRelevanceList = orderServeMapper.selectReCalc();
        couponCustomerRelevanceList.forEach(couponCustomerRelevance -> {
            marketService.achievementReCalc(couponCustomerRelevance.getOrderId());
        });
    }


    @Resource
    OvertimeRecordMapper overtimeRecordMapper;

    @org.junit.Test
    public void plusOverTimeRecord() {
        List<TakeLeaveEvent> takeLeaveEventList = overtimeRecordMapper.plusOverTimeRecord();

        takeLeaveEventList.forEach(takeLeaveEvent -> {

            OvertimeRecord overtimeRecord = OvertimeRecord.builder()
                    .createTime(System.currentTimeMillis())
                    .startTime(takeLeaveEvent.getStartTime())
                    .endTime(takeLeaveEvent.getEndTime())
                    .lastUpdateTime(System.currentTimeMillis())
                    .leftTimeLength(takeLeaveEvent.getTimeLength())
                    .status(1)
                    .totalTimeLength(takeLeaveEvent.getTimeLength())
                    .technicianId(takeLeaveEvent.getApplyTechnicianId())
                    .takeLeaveEventId(takeLeaveEvent.getId())
                    .build();
            overtimeRecordMapper.insert(overtimeRecord);
        });
    }


    @Resource
    TakeLeaveEventMapper takeLeaveEventMapper;

    @org.junit.Test
    public void takeLeaveId() {

        List<OvertimeRecord> overtimeRecordList = takeLeaveEventMapper.takeLeaveId();

        overtimeRecordList.forEach(overtimeRecord -> {
            List<TakeLeaveEvent> takeLeaveEventList = takeLeaveEventMapper.selectList(
                    new LambdaQueryWrapper<TakeLeaveEvent>()
                            .eq(TakeLeaveEvent::getStartTime, overtimeRecord.getStartTime())
                            .eq(TakeLeaveEvent::getEndTime, overtimeRecord.getEndTime())
                            .eq(TakeLeaveEvent::getApplyTechnicianId, overtimeRecord.getTechnicianId())
                            .eq(TakeLeaveEvent::getTimeLength, overtimeRecord.getTotalTimeLength())
            );

            List<OvertimeRecord> overtimeRecordList1 = overtimeRecordMapper.selectList(
                    new LambdaQueryWrapper<OvertimeRecord>()
                            .eq(OvertimeRecord::getStartTime, overtimeRecord.getStartTime())
                            .eq(OvertimeRecord::getEndTime, overtimeRecord.getEndTime())
                            .eq(OvertimeRecord::getTechnicianId, overtimeRecord.getTechnicianId())
                            .eq(OvertimeRecord::getTotalTimeLength, overtimeRecord.getTotalTimeLength())
            );
            Queue<OvertimeRecord> overTimeRecordQueue = new LinkedList<>(overtimeRecordList1);

            if (takeLeaveEventList.size() == overTimeRecordQueue.size()) {
                takeLeaveEventList.forEach(takeLeaveEvent -> {
                    OvertimeRecord overtimeRecord1 = overTimeRecordQueue.poll();
                    overtimeRecord1.setTakeLeaveEventId(takeLeaveEvent.getId());
                    overtimeRecordMapper.updateById(overtimeRecord1);
                });
            }
        });
    }

    @Resource
    OrderManageService orderManageService;

    @org.junit.Test
    public void oneAchievementReCalc() {
        marketService.achievementReCalc(13175);
    }

    /**
     * 重算2020订单完整度
     */
    @org.junit.Test
    public void reCalcOrderDataIntegrity() {


        List<OrderManage> orderManageList = orderManageMapper.selectList(new LambdaQueryWrapper<OrderManage>()
                .gt(OrderManage::getCreateTime, "2020-01-01"));

        orderManageList.forEach(orderManage -> {
            try {
                Double dataIntegrity = orderManageService.countOrderDataRate(orderManage.getId());
                orderManage.setDataIntegrity(dataIntegrity);
                orderManageMapper.updateById(orderManage);
            } catch (Exception e) {

            }
        });
    }


    /**
     * 重算订单金额
     */
    @org.junit.Test
    public void calcOrderAmount() {
        marketService.calcOrderAmount(13431);
    }

    @Resource
    PurchaseSkuMapper purchaseSkuMapper;

    @org.junit.Test
    public void importSku() {
        String filePath = "/Users/huluobin/Library/Containers/com.tencent.WeWorkMac/Data/Library/Application Support/WXWork/Data/1688853793439460/Cache/File/2020-06/价格补录.xlsx";
        File file = new File("/Users/huluobin/Library/Containers/com.tencent.WeWorkMac/Data/Library/Application Support/WXWork/Data/1688853793439460/Cache/File/2020-06/价格补录.xlsx");

        EasyExcel.read(filePath, ImportPurchaseSkuExcel.class, new ExcelListener(purchaseSkuMapper)).sheet().doRead();
    }

    @Resource
    MallProductMapper mallProductMapper;

    @org.junit.Test
    public void importMallProduct() {
        String filePath = "/Users/huluobin/Library/Containers/com.tencent.WeWorkMac/Data/Library/Application Support/WXWork/Data/1688853793439460/Cache/File/2020-06/GOGIRL商城部分SKU价格更改2020.06.12.xlsx";
        EasyExcel.read(filePath, ImportMallProductExcel.class, new MallProductExcelListener(mallProductMapper)).sheet().doRead();

    }

    @org.junit.Test
    public void duplicateCouponFix() {
        List<OrderManage> orderManageList = orderManageMapper.selectBatchIds(Lists.newArrayList("13711,13744,13766,13921".split(",")));

        orderManageList.forEach(orderManage -> {
            BigDecimal discountAmount = orderManage.getDiscountPrice();

            Integer payUser = orderManage.getPayUser();
            Integer orderId = orderManage.getId();

            marketService.calcOrderAmount(orderManage.getId());

            CustomerBalanceRecord customerBalanceRecord = customerBalanceRecordMapper.selectOne(new LambdaQueryWrapper<CustomerBalanceRecord>()
                    .eq(CustomerBalanceRecord::getCustomerId, payUser)
                    .eq(CustomerBalanceRecord::getOrderId, orderId));

            if (customerBalanceRecord != null && customerBalanceRecord.getCurrentBalance() > 0) {
                customerBalanceRecord.setOrderAmount(customerBalanceRecord.getOrderAmount() + (discountAmount.intValue() * 100));
                customerBalanceRecord.setCurrentBalance(customerBalanceRecord.getCurrentBalance() - (discountAmount.intValue() * 100));
                customerBalanceRecordMapper.updateById(customerBalanceRecord);

                CustomerBalance customerBalance = customerBalanceMapper.selectOne(new LambdaQueryWrapper<CustomerBalance>()
                        .eq(CustomerBalance::getCustomerId, payUser));

                customerBalance.setTotalExpenditure(customerBalance.getTotalExpenditure() + (discountAmount.intValue() * 100));
                customerBalance.setBalance(customerBalance.getBalance() - (discountAmount.intValue() * 100));
                customerBalanceMapper.updateById(customerBalance);

            }
        });
    }
}
