package com.gogirl.application.product.mall.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.application.product.mall.MallShoppingCartQryService;
import com.gogirl.domain.order.mall.MallShoppingCart;
import com.gogirl.infrastructure.mapper.order.mall.MallShoppingCartMapper;
import com.gogirl.shared.product.query.dto.MyMallShoppingCartDTO;
import com.gogirl.shared.product.query.qry.MyShoppingCartQuery;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@AllArgsConstructor
public class MallShoppingCartQryServiceImpl implements MallShoppingCartQryService {

    private final MallShoppingCartMapper mallShoppingCartMapper;

    @Override
    public MyMallShoppingCartDTO queryMyShoppingCart(MyShoppingCartQuery qry) {
        List<MallShoppingCart> mallShoppingCartList = mallShoppingCartMapper.selectList(
                new LambdaQueryWrapper<MallShoppingCart>().eq(MallShoppingCart::getCustomerId, qry.getCustomerId())
        );
        MyMallShoppingCartDTO data = new MyMallShoppingCartDTO();

        data.setMallShoppingCartDTOList(mallShoppingCartList);

        data.setItemSum(mallShoppingCartList.stream()
                .map(MallShoppingCart::getNum)
                .mapToInt(Integer::intValue)
                .sum());
        return data;
    }
}
