package com.gogirl.infrastructure.common.interceptor;

import com.gogirl.application.common.xcx.GogirlTokenService;
import com.gogirl.domain.common.xcx.GogirlToken;
import com.gogirl.domain.user.customer.Customer;
import com.gogirl.infrastructure.common.annotation.AuthIgnore;
import com.gogirl.infrastructure.common.exception.ErrorCode;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.StringUtils;
import com.gogirl.infrastructure.mapper.user.customer.CustomerMapper;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;

/**
 * 权限拦截器
 */
@AllArgsConstructor
@Component
@Slf4j
public class AuthHandlerInterceptor implements HandlerInterceptor {

    private final GogirlTokenService gogirlTokenService;
    private final CustomerMapper customerMapper;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {

        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod) handler;
        Method method = handlerMethod.getMethod();

        if (method.isAnnotationPresent(AuthIgnore.class)) {
            return true;
        }

        String token = request.getHeader("token");

        if (request.getRequestURI().contains("no_")) {
            return true;
        }

        String sourceFrom = request.getHeader("sourceFrom");
        if (sourceFrom == null) {
            return true;
        }
        if (sourceFrom.equals("customer")) {
            GogirlToken gogirlToken = gogirlTokenService.getByToken(token);
            if (gogirlToken == null) {
                throw new RRException(ErrorCode.CS_2000);
            } else {
                Customer customer = customerMapper.selectById(gogirlToken.getCustomerId());
                if (customer != null && StringUtils.isEmpty(customer.getPhone())) {
                    throw new RRException(ErrorCode.CS_1001);
                }
            }
        }
        return true;
    }
}
