package com.gogirl.domain.product.serve;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 技法sku
 * </p>
 *
 * @author robbendev
 * @since 2020-05-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="TechniqueSku对象", description="技法sku")
public class TechniqueSku implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "技法名称")
    private String name;

    @ApiModelProperty(value = "技法分类id")
    private Integer techniqueCategoryId;

    private String sku;

    @ApiModelProperty(value = "技术级别")
    private String level;

    @ApiModelProperty(value = "技法简述")
    private String operationalGuidelines;

    @ApiModelProperty(value = "教程视屏链接")
    private String videoPath;

    @ApiModelProperty(value = "话术")
    private String talkingSkill;

    @ApiModelProperty(value = "限定操作时长（分钟）")
    private Integer duration;

    @ApiModelProperty(value = "课程定价")
    private BigDecimal price;

    private Integer createUserId;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createDate;

    @ApiModelProperty(value = "是否删除")
    private Boolean isDelete;

    @ApiModelProperty(value = "1:全手 2：单指 3：单颗 4：根/颗 5：颗 6：全脚")
    private Integer unit;

    @TableField(exist = false)
    private String techniqueCategoryName;

    @ApiModelProperty(value = "")
    @TableField(exist = false)
    private Integer quantity;

}
