package com.gogirl.infrastructure.mapper.order.serve;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.domain.market.coupon.CouponCustomerRelevance;
import com.gogirl.domain.order.serve.OrderServe;
import com.gogirl.domain.store.store.TechnicianAchieve;
import org.apache.ibatis.annotations.Param;

import java.util.List;


public interface OrderServeMapper extends BaseMapper<OrderServe> {

    /**
     * 分页查询美甲师所有业绩
     *
     * @param page
     * @param technicianId
     * @param type
     * @param month
     * @return
     */
    Page<OrderServe> queryPageAchieve(Page<OrderServe> page, @Param("technicianId") Integer technicianId, @Param("type") String type, @Param("month") String month);

    /**
     * 分页查询美甲充值业绩
     *
     * @param page
     * @param technicianId
     * @param month
     * @return
     */
    Page<TechnicianAchieve> queryPageChargeTechnicianAchieve(Page<OrderServe> page,
                                                             @Param("technicianId") Integer technicianId,
                                                             @Param("month") String month,
                                                             @Param("departmentId") Integer departmentId);

    /**
     * 分页查询美甲订单业绩
     *
     * @param page
     * @param technicianId
     * @param type
     * @param month
     * @return
     */
    Page<TechnicianAchieve> queryPageOrderTechnicianAchieve(Page<OrderServe> page,
                                                            @Param("technicianId") Integer technicianId,
                                                            @Param("type") String type,
                                                            @Param("month") String month,
                                                            @Param("departmentId") Integer departmentId);

    /**
     * 同步订单时间
     */
    void syncOrderServeTimes();


    /**
     * 查询需要重算业绩的订单
     *
     * @return
     */
    List<CouponCustomerRelevance> selectReCalc();
}
