package com.gogirl.shared.order;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gogirl.domain.order.serve.OwnProduce;
import com.gogirl.shared.store.StoreTechnicianDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class OrderServeDTO implements Serializable {
    private Integer id;

    @ApiModelProperty("订单id")
    private Integer orderId;

    @ApiModelProperty("美甲顾问id")
    private String technicianIds;

    @ApiModelProperty("预约美甲师姓名")
    private String technicianNames;

    @ApiModelProperty("预约美甲师姓名")
    private String technicianName;

    @ApiModelProperty("服务改价(有正负)")
    private BigDecimal serveChangePrice;

    @ApiModelProperty("价格")
    private BigDecimal price;

    @ApiModelProperty("卡券折扣金额")
    private BigDecimal discountPrice;

    @ApiModelProperty("支付金额")
    private BigDecimal payPrice;

    @ApiModelProperty("业绩")
    private BigDecimal achievement;

    @ApiModelProperty("服务数量")
    private Integer serveNumber;

    @ApiModelProperty("服务评价状态 1-未评价 2-已评价")
    private Integer commentStatus;

    /**
     * 预约服务vo
     */
    @ApiModelProperty("预约服务id")
    private Integer serveId;

    @ApiModelProperty("服务名称")
    private String serveName;

    @ApiModelProperty("图片名称")
    private String servePicturePath;

    @ApiModelProperty("服务单价")
    private BigDecimal servePrice;

    @ApiModelProperty("服务单价")
    private Integer mainServeId;

    @ApiModelProperty("闲时折扣减免的金额")
    private BigDecimal leisureDiscountPrice;

    /**
     * 预约款式vo
     */
    @ApiModelProperty("订单款式id")
    private Integer produceId;

    @ApiModelProperty("款式名字")
    private String produceName;


    @ApiModelProperty("款式图片地址")
    private String producePicturePath;

    @ApiModelProperty("款式当前价格")
    private BigDecimal produceCurrentPrice;

    @ApiModelProperty("款式特价")
    private BigDecimal produceBargainPrice;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date scheduledTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    private Integer lengthTime;

    @ApiModelProperty("订单服务sku")
    private List<OrderServeSkuDTO> orderServeSkuDTOList;

    @ApiModelProperty("订单记录")
    private OrderRecordDTO orderRecordDTO;

    @ApiModelProperty("订单详情折扣")
    private List<CouponOrderRelevanceDTO> couponOrderRelevanceDTOList;

    @ApiModelProperty("订单服务详情")
    private List<OrderServeDescribeDTO> orderServeDescribeDTOList;

    @ApiModelProperty("订单详情服务美甲师")
    private List<StoreTechnicianDTO> storeTechnicianDTOList;

    private Integer actualServeDuration;

    private Integer bindCoupon;

    private BigDecimal discountRate;

    private BigDecimal leisurePrice;

    private OwnProduce ownProduce;

    @ApiModelProperty("是否自带款式 1-是 2-否")
    private Integer isOwnProduce;
}
