package com.gogirl.assembler;


import com.gogirl.domain.order.serve.ScheduleManage;
import com.gogirl.domain.order.serve.ScheduleServe;
import com.gogirl.shared.order.ScheduleManageDTO;
import com.gogirl.shared.order.ScheduleServeDTO;
import lombok.AllArgsConstructor;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

import java.util.function.Function;

@Component
@AllArgsConstructor
public class ScheduleManageDTOAssembler implements Function<ScheduleManage, ScheduleManageDTO> {

    private final ScheduleServeDTOAssembler scheduleServeDTOAssembler;

    @Override
    public ScheduleManageDTO apply(ScheduleManage scheduleManage) {
        ScheduleManageDTO scheduleManageDTO = new ScheduleManageDTO();
        BeanUtils.copyProperties(scheduleManage, scheduleManageDTO);

        scheduleManage.getListScheduleServer().forEach(scheduleServe -> {
            scheduleManageDTO.getScheduleServeDTOList().add(scheduleServeDTOAssembler.apply(scheduleServe));
        });


        return scheduleManageDTO;
    }

    @Component
    static class ScheduleServeDTOAssembler implements Function<ScheduleServe, ScheduleServeDTO> {

        @Override
        public ScheduleServeDTO apply(ScheduleServe scheduleServe) {
            ScheduleServeDTO scheduleServeDTO = new ScheduleServeDTO();
            BeanUtils.copyProperties(scheduleServe, scheduleServeDTO);
            if (scheduleServe.getOwnProduce() != null) {
                scheduleServeDTO.setOwnProduce(scheduleServe.getOwnProduce());
            }
            return scheduleServeDTO;
        }
    }


}
