package com.gogirl.shared.store.query.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * Created by yinyong on 2018/9/18.
 */

@Data
@ApiModel("美甲师")
public class StoreTechnicianDTO {


    private Integer id;

    @ApiModelProperty("美甲师端小程序openid")
    private String openid;

    @ApiModelProperty("头像url地址")
    private String picturePath;

//    @ApiModelProperty("技师编号")
//    private String technicianNo;

    @ApiModelProperty("姓名")
    private String name;

    @ApiModelProperty("店铺编号")
    private Integer departmentId;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("手机号码")
    private String mobile;

    @ApiModelProperty("拥有权限")
    private String userAuthority;

    @ApiModelProperty("等级")
    private String grade;

    @ApiModelProperty("资历")
    private Double seniority;

    @ApiModelProperty("信息填写完整度")
    private Double informationIntegrity;

    @ApiModelProperty("投诉次数")
    private Integer complaintNumber;

    @ApiModelProperty("投诉原因")
    private String complaintReason;

    @ApiModelProperty("投诉次数")
    private Integer serviceNumberTotal;

    @ApiModelProperty("累计服务金额")
    private BigDecimal serviceMoneyTotal;

    @ApiModelProperty("累计开卡金额")
    private BigDecimal applyCardMoneyTotal;

    @ApiModelProperty("分数")
    private Double score;

    @ApiModelProperty("员工id store_user表id")
    private Integer userId;

    @ApiModelProperty("状态： 1#在职 2#离职")
    private Integer status = 0;

    @ApiModelProperty("员工短码")
    private String shortCode;

    @ApiModelProperty("员工短码")
    private Date entryTime;

}
