package com.gogirl.domain.store.store;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.gogirl.domain.order.serve.ScheduleServe;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@ApiModel("每天排班记录")
@TableName("store_classes_technician")
@Builder
@Data
public class StoreClassesTechnician implements Serializable {

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("美甲师id 这里是technician_id")
    private Integer userId;

    @ApiModelProperty("哪一天")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date days;

    @ApiModelProperty("班次id")
    private Integer classes;

    private Integer status;

    @ApiModelProperty("品牌ID")
    private Integer brandId;

    /**
     * 非数据库字段
     */
    @ApiModelProperty("班次")
    @TableField(exist = false)
    private StoreClasses classesManage;

    @ApiModelProperty("美甲师")
    @TableField(exist = false)
    private StoreTechnician technicianManage;

    @ApiModelProperty("美甲师正在做的服务")
    @TableField(exist = false)
    private List<ScheduleServe> listScheduleServe;
}
