package com.gogirl.domain.market.timescard;


import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.gogirl.domain.store.store.StoreManage;
import com.gogirl.infrastructure.common.annotation.DictParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@ApiModel("次卡种类")
@TableName("times_card_type")
@Data
public class TimesCardType implements Serializable {
    //次卡上架
    public static final Integer STATUS_ON = 1;
    //次卡下架
    public static final Integer STATUS_OFF = 2;

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("次卡名字")
    private String name;

    @ApiModelProperty("次卡次数")
    private Integer sumTimes;

    @ApiModelProperty("单次优惠价格")
    private BigDecimal discountAmount;

    @ApiModelProperty("单次算业绩价格")
    private BigDecimal payAmount;

    @ApiModelProperty("次卡有效期天数")
    private Integer validDays;

    @ApiModelProperty("提示、用户须知")
    private String notes;

    @ApiModelProperty("分类 1-美甲次卡 2-美睫次卡")
    private Integer type;

    private Date createTime;

    @DictParam(dictCode = "TIMES_CARD_TYPE_STATUS", dictValueParam = "statusStr")
    @ApiModelProperty("1上架;2下架")
    private Integer status;

    @ApiModelProperty("品牌id")
    private Integer brandId;

    @TableField(exist = false)
    private String statusStr;

    @TableField(exist = false)
    private Integer sumCount;

    @TableField(exist = false)
    private List<TimesCardTypeContent> cardTypeCententList;

    @TableField(exist = false)
    private List<StoreManage> storeList;

}
