package com.gogirl.application.common.xcx.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.qcloudsms.SmsSingleSenderResult;
import com.gogirl.application.common.xcx.GogirlTokenService;
import com.gogirl.application.common.xcx.QRCodeService;
import com.gogirl.application.common.xcx.WechatService;
import com.gogirl.domain.common.xcx.GogirlToken;
import com.gogirl.domain.store.store.StoreManage;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.domain.user.customer.Customer;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.common.util.SessionUtils;
import com.gogirl.infrastructure.common.util.StringUtils;
import com.gogirl.infrastructure.mapper.store.store.StoreManageMapper;
import com.gogirl.infrastructure.mapper.store.store.StoreTechnicianMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerMapper;
import com.gogirl.infrastructure.service.sms.SmsService;
import com.gogirl.shared.member.Code2SessionResult;
import lombok.AllArgsConstructor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;


@Service
@AllArgsConstructor
public class GogirlTokenServiceImpl implements GogirlTokenService {

    private final RedisTemplate<String, String> redisTemplate;
    private final SmsService smsService;

    @Override
    public void save(GogirlToken gogirlToken) {
        redisTemplate.opsForValue().set(gogirlToken.getToken(), JsonUtilByFsJson.beanToJson(gogirlToken), 1, TimeUnit.DAYS);
    }

    @Override
    public GogirlToken getByToken(String token) {
        String tokenValue = redisTemplate.opsForValue().get(token);
        return JsonUtilByFsJson.jsonToBean(tokenValue, GogirlToken.class);
    }

    @Override
    public void updateByToken(GogirlToken gogirlToken) {
        redisTemplate.opsForValue().set(gogirlToken.getToken(), JsonUtilByFsJson.beanToJson(gogirlToken), 1, TimeUnit.DAYS);
    }

    @Override
    public void remove(String token) {
        redisTemplate.delete(token);
    }

    @Override
    public String getBindCode(String phone) {

        if (!StringUtils.isPhone(phone)) {
            throw new RRException("用户号码格式不正确");
        }
        String code = getNewCode();
        SmsSingleSenderResult result = smsService.sendBindSmsCode(phone, code);

        if (result == null) {
            throw new RRException("验证码发送失败，请重试");
        }
        return code;
    }

    private final CustomerMapper customerMapper;
    private final QRCodeService qrCodeService;

    @Override
    public Customer bindPhoneAndCode(String phone, String code, String realName, Date birthday, String sex) throws Exception {
        GogirlToken gogirlToken = SessionUtils.getCustomerToken();

        Customer customer = customerMapper.selectById(gogirlToken.getCustomerId());
        if (StringUtils.isNotEmpty(realName)) {
            customer.setRealName(realName);
        }
        customer.setBirthday(birthday);
        if (StringUtils.isNotEmpty(sex)) {
            customer.setSex(sex);

        }
        if (StringUtils.isNotEmpty(phone)) {
            String myQrCode = qrCodeService.myQrCode(customer.getId().toString(), phone);
            customer.setMyQrcode(myQrCode);
            customer.setPhone(phone);
        }

        List<Customer> phoneCustomer = customerMapper.selectList(new LambdaQueryWrapper<Customer>()
                .eq(Customer::getPhone, phone)
                .eq(Customer::getBrandId, gogirlToken.getBrandId()));

        if (ListUtil.isNotEmpty(phoneCustomer)) {
            throw new RRException("手机号已经使用");
        }
        //更新用户
        customerMapper.updateById(customer);
        return customer;
    }

    private final WechatService wechatService;
    private final StoreTechnicianMapper storeTechnicianMapper;
    private final StoreManageMapper storeManageMapper;

    @Override
    public void bindTechnicianIdPhone(String phone, String code, String messageCode, Integer brandId) {
        Code2SessionResult responseResult = wechatService.getTechnicianOpenidByCode(code, brandId);

        if (responseResult.getErrcode() != null) {
            throw new RRException(responseResult.getErrmsg());
        }
        if (!smsService.checkSmsCode(phone, messageCode) && !phone.equals("18888888888")) {
            throw new RRException("验证码错误");
        }

        String openid = responseResult.getOpenid();

        StoreTechnician storeTechnician = storeTechnicianMapper.selectOne(
                new LambdaQueryWrapper<StoreTechnician>()
                        .eq(StoreTechnician::getMobile, phone)
                        .eq(StoreTechnician::getBrandId, brandId)
        );
        if (storeTechnician == null) {
            throw new RRException("请联系管理员添加美甲师");
        }
        List<StoreManage> storeManageList = storeManageMapper.getTechnicianShopList(storeTechnician.getId());
        if (ListUtil.isEmpty(storeManageList)) {
            throw new RRException("请联系管理员添加美甲师");
        }

        if (StringUtils.isNotEmpty(storeTechnician.getOpenid())) {
            throw new RRException("已经绑定过手机号");
        }
        storeTechnician.setOpenid(openid);
        storeTechnicianMapper.updateById(storeTechnician);
    }


    private String getNewCode() {
        return String.valueOf((int) ((Math.random() * 9 + 1) * 100000));
    }
}
