package com.gogirl.interfaces.store.career;


import com.gogirl.application.store.career.ITechScoreRulesService;
import com.gogirl.dto.TechScoreResp;
import com.gogirl.infrastructure.common.base.JsonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-03-12
 */
@Api(tags = "美甲师评分接口")
@RestController
@AllArgsConstructor
public class TechScoreRulesController {

    private final ITechScoreRulesService techScoreRulesService;

    @ApiOperation("美甲师评分")
    @GetMapping("/technician/getTechScore")
    public JsonResult<TechScoreResp> getTechScore() {
        TechScoreResp techScoreResp = techScoreRulesService.getTechScore();
        return JsonResult.success(techScoreResp);
    }

}
