package com.gogirl.interfaces.product.serve;

import com.gogirl.application.product.serve.BaseBroadcastService;
import com.gogirl.domain.product.serve.BaseBroadcast;
import com.gogirl.infrastructure.common.base.JsonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * Created by yinyong on 2018/9/11.
 */

@RestController
@Api(tags = {"首页banner轮播图"}, value = "首页banner轮播图")
public class BroadcastController {

    private final BaseBroadcastService baseBroadcastService;

    public BroadcastController(BaseBroadcastService baseBroadcastService) {
        this.baseBroadcastService = baseBroadcastService;
    }

    @ApiOperation(value = "1.查询轮播图列表", notes = "查询轮播图列表")
    @GetMapping("/customer/broadcast/queryBroadcast")
    public JsonResult<List<BaseBroadcast>> queryBroadcast(@RequestParam(required = false) Integer positionType) {
        List<BaseBroadcast> baseBroadcastList = baseBroadcastService.queryBroadcast(positionType);
        return JsonResult.success(baseBroadcastList);
    }

}
