package com.gogirl.domain.order.mall;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 商城订单  - 美甲师
 * </p>
 *
 * @author robbendev
 * @since 2020-06-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "MallOrderTechnician对象", description = "商城订单  - 美甲师")
public class MallOrderTechnician implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "订单id :mall_order.id")
    private Long mallOrderId;

    @ApiModelProperty(value = "美甲师id : store_technician.id")
    private Integer technicianId;

    @ApiModelProperty(value = "美甲师订单业绩")
    private BigDecimal achievement;


}
