package com.gogirl.domain.order.mall;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel("商城订单详情")
@Data
@TableName("mall_order_detail")
@Builder
@AllArgsConstructor
public class MallOrderDetail implements Serializable {

    public static final Integer REFUND_STATUS_REFUNDING = 1;
    public static final Integer REFUND_STATUS_NORMAL = 0;
    public static final Integer REFUND_STATUS_REFUNDED = 2;

    @TableId(type = IdType.ID_WORKER)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("订单id")
    private Long orderId;

    @ApiModelProperty("商定的id")
    private Long productId;

    @ApiModelProperty("数量")
    private Integer num;
    /**
     * 冗余Product字段
     */
    private String productSku;

    @ApiModelProperty("商品名称")
    private String productName;

    @ApiModelProperty("商品封面图")
    private String coverImages;

    @ApiModelProperty("商品价格")
    private BigDecimal price;

    @ApiModelProperty("商品规格")
    private String specification;

    @ApiModelProperty("规格单位")
    private String unit;

    /**
     *
     */
    @ApiModelProperty("订单详情总金额")
    private BigDecimal amount;

    @ApiModelProperty("详情优惠金额")
    private BigDecimal discountAmount;

    @ApiModelProperty("详情支付总金额")
    private BigDecimal payAmount;

    @ApiModelProperty("0-正常 1-退款中 2-已退款")
    private Integer refundStatus;

    public MallOrderDetail() {

    }
}
