package com.gogirl.interfaces.store;

import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.mapper.store.StoreTechnicianMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@AllArgsConstructor
@Api("美甲师接口")
@RestController
public class StoreTechnicianController {
    private final StoreTechnicianMapper storeTechnicianMapper;


    @ApiOperation("/查询美甲师信息")
    @GetMapping("/customer/technician/getById")
    public JsonResult<StoreTechnician> getById(@RequestParam Integer id) {
        return JsonResult.success(storeTechnicianMapper.selectById(id));
    }
}
