package com.gogirl.interfaces.order.purchase;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.application.order.purchase.PurchaseOrderCmdService;
import com.gogirl.application.order.purchase.PurchaseOrderQryService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.order.purchase.PurchaseOrder;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.mapper.order.purchase.PurchaseOrderMapper;
import com.gogirl.infrastructure.util.SessionUtils;
import com.gogirl.shared.member.order.command.CreatePurchaseOrderCommand;
import com.gogirl.shared.order.purchase.query.qry.PurchaseOrderPageQuery;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 采购单 前端控制器
 * </p>
 *
 * @author luobin
 * @since 2019-11-26
 */
@RestController
@AllArgsConstructor
public class PurchaseOrderController {


    private final PurchaseOrderQryService purchaseOrderQryService;
    private final PurchaseOrderCmdService purchaseOrderCmdService;

    private final PurchaseOrderMapper purchaseOrderMapper;
    private final GogirlTokenService gogirlTokenService;

    @ApiOperation("分页查询采购订单")
    @RequestMapping("/technician/purchaseOrder/queryPagePurchaseOrder")
    public JsonResult<Page<PurchaseOrder>> queryPagePurchaseOrder(@RequestHeader String token,
                                                                  @RequestBody PurchaseOrderPageQuery qry) {

        StoreTechnician storeTechnician = SessionUtils.getStoreTechnician();
        GogirlToken gogirlToken = gogirlTokenService.getByToken(token);
        qry.setTechnicianId(storeTechnician.getTechnicianId());
        qry.setDepartmentId(storeTechnician.getDepartmentId());
        Page<PurchaseOrder> page = (Page<PurchaseOrder>) purchaseOrderQryService.queryPagePurchaseOrder(qry);
        return JsonResult.success(page);
    }


    @ApiOperation("提交采购订单")
    @PostMapping("/technician/purchaseOrder/submitPurchaseOrder")
    public JsonResult<Void> submitPurchaseOrder(@RequestHeader String token,
                                                @RequestBody List<CreatePurchaseOrderCommand> cmd) {
        StoreTechnician storeTechnician = SessionUtils.getStoreTechnician();

        cmd.forEach(val -> {
            val.setCreater(storeTechnician.getTechnicianId());
            val.setCreaterName(storeTechnician.getName());
        });
        purchaseOrderCmdService.createPurchaseOrder(cmd);
        return JsonResult.success();
    }

    @ApiOperation("更新采购订单")
    @PostMapping("/technician/purchaseOrder/updatePurchaseOrder")
    public JsonResult<Void> updatePurchaseOrder(@RequestBody PurchaseOrder purchaseOrder) {
        return JsonResult.success();
    }

    @ApiOperation("检查采购订单")
    @GetMapping("/technician/purchaseOrder/checkPurchaseOrder")
    public JsonResult<Void> checkPurchaseOrder(@RequestParam Integer id) {
        PurchaseOrder purchaseOrder = purchaseOrderMapper.selectById(id);
        purchaseOrder.setStatus(6);
        purchaseOrderMapper.updateById(purchaseOrder);
        return JsonResult.success();
    }
}
