package com.gogirl.infrastructure.util;

import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.domain.user.Customer;

public class SessionUtils {

    private static final ThreadLocal<StoreTechnician> technicianThreadLocal = new ThreadLocal<>();
    private static final ThreadLocal<Customer> customerThreadLocal = new ThreadLocal<>();

    public static void putStoreTechnician(StoreTechnician storeTechnician) {
        technicianThreadLocal.set(storeTechnician);
    }

    public static StoreTechnician getStoreTechnician() {
        return technicianThreadLocal.get();
    }

    public static void removeStoreTechnician() {
        technicianThreadLocal.remove();
    }

    public static void putCustomer(Customer customer) {
        customerThreadLocal.set(customer);
    }

    public static Customer getCustomer() {
        return customerThreadLocal.get();
    }

    public static void removeCustomer() {
        customerThreadLocal.remove();
    }

}
