package com.gogirl.domain.product.serve;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;


/**
 * Created by yinyong on 2018/8/20.
 * 款式
 */
@ApiModel("款式")
@Data

@TableName("base_produce")
public class BaseProduce implements Serializable {

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("款式名称")
    private String name;

    @ApiModelProperty("图片")
    private String picturePath;
    ;
    @ApiModelProperty("1-上线 2-下线")
    private String status;

    @ApiModelProperty("描述")
    private String details;

    @ApiModelProperty("点赞总次数")
    private Integer praiseSum;

    @ApiModelProperty("现价、特价")
    private BigDecimal currentPrice;

    @ApiModelProperty("原价")
    private BigDecimal bargainPrice;

    @ApiModelProperty("服务简介")
    private String briefIntroduction;

    @ApiModelProperty("子标题")
    private String subTitle;

    private Integer serviceId;

    private Integer serviceDuration;

    private Integer produceLabelId;

    /**
     * 非数据库字段
     */
    @TableField(exist = false)
    private BaseServe serve;

    @TableField(exist = false)
    private PraiseRecord praiseRecord;

    @TableField(exist = false)
    private List<BaseProduceSku> listProduceSku;


    /**
     * 没用上的 但是写在mapper文件里面的
     */
    private String type;

    private String label;

    private Integer shopSort;

    private String reqGrade;

    private String remark;

    @TableField(exist = false)
    private String serveName;

    @TableField(exist = false)
    private BigDecimal price;
}
