package com.gogirl.assembler;

import com.gogirl.domain.market.serve.Coupon;
import com.gogirl.shared.market.query.dto.CouponDTO;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

import java.util.function.Function;

@Component
public class CouponDTOAssembler implements Function<Coupon, CouponDTO> {
    @Override
    public CouponDTO apply(Coupon coupon) {
        CouponDTO couponDTO = new CouponDTO();
        BeanUtils.copyProperties(coupon, couponDTO);
        return couponDTO;
    }
}
