package com.gogirl.application.xcx.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.xcx.CustomerMessageService;
import com.gogirl.domain.user.CustomerMessage;
import com.gogirl.infrastructure.mapper.user.CustomerMessageMapper;
import com.gogirl.shared.user.command.ReadMessageCommand;
import com.gogirl.shared.user.query.qry.CustomerMessagePageQuery;
import org.springframework.stereotype.Service;

@Service
public class CustomerMessageServiceImpl extends ServiceImpl<CustomerMessageMapper, CustomerMessage> implements CustomerMessageService {


    @Override
    public void readMessage(ReadMessageCommand cmd) {
        CustomerMessage customerMessage = this.getById(cmd.getCustomerMessageId());
        customerMessage.setStatus(CustomerMessage.STATUS_READIED);
        this.updateById(customerMessage);
    }

    @Override
    public Page<CustomerMessage> queryPageMessage(CustomerMessagePageQuery qry) {
        LambdaQueryWrapper<CustomerMessage> wrapper = new LambdaQueryWrapper<>();
        if (qry.getCustomerId() != null) {
            wrapper.eq(CustomerMessage::getCustomerId, qry.getCustomerId());
        }
        if (qry.getStatus() != null) {
            wrapper.eq(CustomerMessage::getStatus, qry.getStatus());
        }
        if (qry.getType() != null) {
            wrapper.eq(CustomerMessage::getType, qry.getType());
        }
        IPage<CustomerMessage> page = new Page<>();
        return (Page<CustomerMessage>) this.page(page, wrapper);
    }
}
