package com.gogirl.application.user.customer;

import com.baomidou.mybatisplus.extension.service.IService;
import com.gogirl.domain.user.Customer;

import java.security.InvalidAlgorithmParameterException;

public interface CustomerService extends IService<Customer> {


    /**
     * 根据手机号查询会员
     *
     * @param phone phone
     * @return customer
     */
    Customer selectByPhone(String phone);

    /**
     * 根据id查询会员
     *
     * @param scheduledUser id
     * @return customer
     */
    Customer selectByCustomerId(Integer scheduledUser);


    /**
     * 用户登陆
     *
     * @param code 微信小程序code
     * @return 服务器登陆状态token
     */
    String login(String code);


    /**
     * 授权地址信息
     *
     * @param customerId
     * @param province
     * @param city
     * @param area
     * @param street
     */
    void bindAddressInfo(Integer customerId, String province, String city, String area, String street);


    /**
     * 授权信息
     *
     * @param token
     * @param encryptedData
     * @param iv
     * @return
     */
    Customer authorized1(String token, String encryptedData, String iv) throws InvalidAlgorithmParameterException;

    /**
     * 授权手机号码
     *
     * @param token
     * @param encryptedData
     * @param iv
     * @return
     */
    Customer authorizedPhone(String token, String encryptedData, String iv) throws InvalidAlgorithmParameterException;

    /**
     * 根据token获取customer
     * @param token
     * @return
     */
    Customer getUserInfo(String token) throws Exception;
}
