package com.gogirl.application.store.store.impl;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.store.store.StoreManageService;
import com.gogirl.domain.store.store.StoreManage;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.infrastructure.mapper.store.StoreManageMapper;
import com.gogirl.infrastructure.util.SessionUtils;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by yinyong on 2018/9/17.
 */
@Service
@AllArgsConstructor
public class StoreManageServiceImpl extends ServiceImpl<StoreManageMapper, StoreManage> implements StoreManageService {

    private final StoreManageMapper storeManageMapper;

    @Override
    public List<StoreManage> listShopManageForPage(StoreManage storeManage) {
        return storeManageMapper.listShopManageForPage(storeManage);
    }

    @Override
    public StoreManage getShopManageForDetail(Integer id) {
        return storeManageMapper.getShopManageForDetail(id);
    }

    @Override
    public List<StoreManage> getTechnicianShopList() {
        StoreTechnician storeTechnician = SessionUtils.getStoreTechnician();
        return storeManageMapper.getTechnicianShopList(storeTechnician.getId());
    }
}
