package com.gogirl.application.store.store.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.application.store.store.CareerCmdService;
import com.gogirl.domain.store.career.Works;
import com.gogirl.domain.store.career.WorksImages;
import com.gogirl.domain.store.training.TrainingStartClassLogTechnician;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.mapper.store.TrainingStartClassLogTechnicianMapper;
import com.gogirl.infrastructure.mapper.store.WorksMapper;
import com.gogirl.shared.store.command.SignUpTrainingCommand;
import com.gogirl.shared.store.command.SubmitFeedbackCommand;
import com.gogirl.shared.store.command.SubmitWorksCommand;
import com.gogirl.shared.store.query.dto.CareerDTO;
import com.gogirl.shared.store.query.dto.TrainingStartClassDTO;
import com.gogirl.shared.store.query.dto.WorksDTO;
import com.gogirl.shared.store.query.qry.TrainingStartClassQuery;
import com.gogirl.shared.store.query.qry.WorksQuery;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.stream.Collectors;

@Service
@Slf4j
@AllArgsConstructor
public class CareerCmdServiceImpl implements CareerCmdService {


    private final TrainingStartClassLogTechnicianMapper trainingStartClassLogTechnicianMapper;
    private final WorksMapper worksMapper;

    @Override
    public void submitWorks(SubmitWorksCommand cmd) {
        Works works = new Works();
        works.setCreateTime(System.currentTimeMillis());
        works.setRemarks(cmd.getRemarks());
        works.setTechnicianId(cmd.getTechnicianId());
        works.setWorksImagesList(cmd.getImageUrlList()
                .stream()
                .map(imageUrl -> {
                    WorksImages worksImages = new WorksImages();
                    worksImages.setImageUrl(imageUrl);
                    return worksImages;
                })
                .collect(Collectors.toSet()));

        worksMapper.insert(works);
    }

    @Override
    public void signUpTraining(SignUpTrainingCommand cmd) {

        TrainingStartClassLogTechnician trainingStartClassLogTechnician = trainingStartClassLogTechnicianMapper
                .selectOne(new LambdaQueryWrapper<TrainingStartClassLogTechnician>()
                        .eq(TrainingStartClassLogTechnician::getTrainingStartClassId, cmd.getTrainingStartClassId())
                        .eq(TrainingStartClassLogTechnician::getTechnicianId, cmd.getTechnicianId()));

        if (trainingStartClassLogTechnician != null) {
            throw new RRException(500, "您已经报名过该课程");
        }


        trainingStartClassLogTechnician = TrainingStartClassLogTechnician
                .builder()
                .trainingStartClassId(cmd.getTrainingStartClassId())
                .technicianId(cmd.getTechnicianId())
                .createDate(new Date())
                .build();

        trainingStartClassLogTechnicianMapper.insert(trainingStartClassLogTechnician);
    }

    @Override
    @Transactional(timeout = 10000)
    public void submitFeedBack(SubmitFeedbackCommand cmd) {

        TrainingStartClassLogTechnician trainingStartClassLogTechnician =
                trainingStartClassLogTechnicianMapper.selectById(cmd.getTrainingStartClassLogTechnicianId());

        trainingStartClassLogTechnician.setFeedback(cmd.getFeedBackJson());
        trainingStartClassLogTechnician.setCreateDate(new Date());
        trainingStartClassLogTechnicianMapper.updateById(trainingStartClassLogTechnician);

    }

    @Override
    public Page<WorksDTO> queryWorks(WorksQuery qry) {
        return null;
    }

    @Override
    public Page<TrainingStartClassDTO> queryPageClass(TrainingStartClassQuery qry) {
        return null;
    }

    @Override
    public CareerDTO career(Integer technicianId) {
        return null;
    }
}
