package com.gogirl.application.market.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.application.market.*;
import com.gogirl.application.order.serve.OrderServeService;
import com.gogirl.domain.market.serve.*;
import com.gogirl.domain.order.serve.OrderManage;
import com.gogirl.domain.order.serve.OrderServe;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.mapper.market.CouponCustomerRelevanceMapper;
import com.gogirl.infrastructure.mapper.market.CouponMapper;
import com.gogirl.infrastructure.mapper.market.TimesCardCustomerRelevanceMapper;
import com.gogirl.infrastructure.mapper.market.TimesCardOrderServeDetailMapper;
import com.gogirl.infrastructure.mapper.order.serve.OrderManageMapper;
import com.gogirl.infrastructure.mapper.order.serve.OrderServeMapper;
import com.gogirl.shared.market.command.SetTimesCardCommand;
import com.gogirl.shared.market.command.SetUpInnerCouponCommand;
import com.gogirl.shared.market.command.SetUpOuterCouponCommand;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service
@AllArgsConstructor
@Slf4j
@Transactional
public class MarketServiceImpl implements MarketService {


    private final CouponMapper couponMapper;

    private final CouponCustomerRelevanceService couponCustomerRelevanceService;

    private final CouponOrderRelevanceService couponOrderRelevanceService;

    private final OrderManageMapper orderManageMapper;
    private final OrderServeMapper orderServeMapper;

    private final TimesCardOrderServeDetailMapper timesCardOrderServeDetailMapper;
    private final TimesCardCustomerRelevanceMapper timesCardCustomerRelevanceMapper;
    private final CouponCustomerRelevanceMapper couponCustomerRelevanceMapper;

    //    private final OrderManageService orderManageService;
    private final OrderServeService orderServeService;
    private final TimesCardUsedRecordService timesCardUsedRecordService;
    private final TimesCardCustomerRelevanceService timesCardCustomerRelevanceService;


    @Override
    public void setUpInnerCoupon(SetUpInnerCouponCommand cmd) {

        if (cmd.getOrderId() == null) {
            throw new RRException();
        }

        //清除之前设置的卡券关联
        List<CouponCustomerRelevance> setterCouponCustomerRelevanceList = couponCustomerRelevanceService
                .list(new LambdaQueryWrapper<CouponCustomerRelevance>()
                        .eq(CouponCustomerRelevance::getOrderId, cmd.getOrderId())
                        .eq(CouponCustomerRelevance::getSourceType, CouponCustomerRelevance.SOURCE_TYPE_INNER));

        setterCouponCustomerRelevanceList.forEach(couponCustomerRelevance -> {
            couponCustomerRelevance.setOrderId(null);
            couponCustomerRelevance.setState(null);
        });

        if (ListUtil.isNotEmpty(setterCouponCustomerRelevanceList)) {
            couponCustomerRelevanceService.saveOrUpdateBatch(setterCouponCustomerRelevanceList);
        }

        couponOrderRelevanceService.remove(new LambdaQueryWrapper<CouponOrderRelevance>()
                .eq(CouponOrderRelevance::getOrderId, cmd.getOrderId())
                .in(CouponOrderRelevance::getCouponCustomerRelevanceId, setterCouponCustomerRelevanceList.stream().map(CouponCustomerRelevance::getId).collect(Collectors.toList())));

        //set
        List<CouponCustomerRelevance> couponCustomerRelevanceList = (List<CouponCustomerRelevance>) couponCustomerRelevanceService.listByIds(cmd.getInnerCouponCustomerRelevanceIds());
        couponCustomerRelevanceList.forEach(couponCustomerRelevance -> {
            couponCustomerRelevance.setOrderId(cmd.getOrderId());
            //选择使用
            couponCustomerRelevance.setState(CouponCustomerRelevance.STATE_CHOSE);
        });
        couponCustomerRelevanceService.saveOrUpdateBatch(couponCustomerRelevanceList);

    }

    @Override
    public void setUpOuterCoupon(SetUpOuterCouponCommand cmd) {

        if (cmd.getOrderId() == null) {
            throw new RRException();
        }
        //删除之前设置的外部券
        couponCustomerRelevanceService.remove(
                new LambdaQueryWrapper<CouponCustomerRelevance>()
                        .eq(CouponCustomerRelevance::getOrderId, cmd.getOrderId())
                        .eq(CouponCustomerRelevance::getSourceType, CouponCustomerRelevance.SOURCE_TYPE_OUTER)
        );

        cmd.getOuterCouponIds().forEach(outerCouponId -> {
            Coupon coupon = couponMapper.selectById(outerCouponId);

            //根据卡券类型发一张券并且设置状态 已选择
            CouponCustomerRelevance couponCustomerRelevance = CouponCustomerRelevance.getInstance(coupon);
            couponCustomerRelevance.setOrderId(cmd.getOrderId());
            couponCustomerRelevance.setCustomerId(cmd.getCustomerId());
            //选择
            couponCustomerRelevance.setState(CouponCustomerRelevance.STATE_CHOSE);

            if (!couponCustomerRelevance.isValid()) {
                throw new RRException("卡券过期");
            }
            couponCustomerRelevanceService.save(couponCustomerRelevance);
        });

    }

    @Override
    public void setTimesCard(SetTimesCardCommand cmd) {

        if (cmd.getOrderId() == null) {
            throw new RRException();
        }

        //删除已经绑定的次卡
        timesCardUsedRecordService.remove(new LambdaQueryWrapper<TimesCardUsedRecord>()
                .eq(TimesCardUsedRecord::getOrderId, cmd.getOrderId()));

        cmd.getTimesCardIds().forEach(id -> {
            //用户次卡
            TimesCardCustomerRelevance cardCustomerRelevance = timesCardCustomerRelevanceService.getById(id);
            //当前次卡所有使用记录
            List<TimesCardUsedRecord> timesCardUsedRecordList = timesCardUsedRecordService.list(new LambdaQueryWrapper<TimesCardUsedRecord>().eq(TimesCardUsedRecord::getCardRelevanceCustomerId, cardCustomerRelevance.getId()));

            if (timesCardUsedRecordList
                    .stream()
                    .filter(record -> record.getStatus().equals(TimesCardUsedRecord.STATUS_USED))
                    .count() == cardCustomerRelevance.getSumTimes()) {
                throw new RRException("次卡已经用完");
            }

            //如果次卡还有次数就新建关联
            if (cardCustomerRelevance.getSumTimes() > timesCardUsedRecordList.size()) {
                TimesCardUsedRecord timesCardUsedRecord = TimesCardUsedRecord.builder()
                        .orderId(cmd.getOrderId())
                        .cardTypeId(cardCustomerRelevance.getCardTypeId())
                        .name(cardCustomerRelevance.getName())
                        .cardRelevanceCustomerId(cardCustomerRelevance.getId())
                        .time(new Date())
                        //选择使用
                        .status(TimesCardUsedRecord.STATUS_CHOSE)
                        .customerId(cardCustomerRelevance.getCustomerId())
                        .discountAmount(cardCustomerRelevance.getDiscountAmount())
                        .payAmount(cardCustomerRelevance.getPayAmount())
                        .type(1)
                        .build();
                timesCardUsedRecordService.saveOrUpdate(timesCardUsedRecord);
            }
            //替换
            else {
                TimesCardUsedRecord timesCardUsedRecord = timesCardUsedRecordList
                        .stream()
                        .filter(record -> record.getStatus().equals(TimesCardUsedRecord.STATUS_CHOSE))
                        .findAny()
                        .orElseThrow(RRException::new);

                timesCardUsedRecord.setOrderId(cmd.getOrderId());
                timesCardUsedRecord.setTime(new Date());
                timesCardUsedRecordService.saveOrUpdate(timesCardUsedRecord);
            }
        });
    }


    @Override
    public void setterOrderMarket(Integer orderId) {


        //订单使用的内部券
        List<CouponCustomerRelevance> innerCouponCustomerRelevanceServiceList = couponCustomerRelevanceService
                .list(new LambdaQueryWrapper<CouponCustomerRelevance>()
                        .eq(CouponCustomerRelevance::getOrderId, orderId)
                        .eq(CouponCustomerRelevance::getState, 1)
                        .eq(CouponCustomerRelevance::getType, 0));
        innerCouponCustomerRelevanceServiceList.forEach(couponCustomerRelevance -> couponCustomerRelevance.setState(CouponCustomerRelevance.STATE_USED));
        if (ListUtil.isNotEmpty(innerCouponCustomerRelevanceServiceList)) {
            couponCustomerRelevanceService.saveOrUpdateBatch(innerCouponCustomerRelevanceServiceList);
        }

        //订单使用的外部券
        List<CouponCustomerRelevance> outerCouponCustomerRelevanceServiceList = couponCustomerRelevanceService
                .list(new LambdaQueryWrapper<CouponCustomerRelevance>()
                        .eq(CouponCustomerRelevance::getOrderId, orderId)
                        .eq(CouponCustomerRelevance::getState, 1)
                        .eq(CouponCustomerRelevance::getType, 1));
        outerCouponCustomerRelevanceServiceList.forEach(couponCustomerRelevance -> couponCustomerRelevance.setState(CouponCustomerRelevance.STATE_USED));
        if (ListUtil.isNotEmpty(outerCouponCustomerRelevanceServiceList)) {
            couponCustomerRelevanceService.saveOrUpdateBatch(outerCouponCustomerRelevanceServiceList);
        }

        //订单使用的次卡
        List<TimesCardUsedRecord> timesCardUsedRecordList = timesCardUsedRecordService
                .list(new LambdaQueryWrapper<TimesCardUsedRecord>()
                        .eq(TimesCardUsedRecord::getOrderId, orderId)
                        .eq(TimesCardUsedRecord::getStatus, 1));
        timesCardUsedRecordList.forEach(timesCardUsedRecord -> timesCardUsedRecord.setStatus(TimesCardUsedRecord.STATUS_USED));
        if (ListUtil.isNotEmpty(timesCardUsedRecordList)) {
            timesCardUsedRecordService.saveOrUpdateBatch(timesCardUsedRecordList);
        }
    }

    /**
     * 更新订单 使用次卡 使用外部券 使用内部券之后需要调用这个方法
     * 结算订单
     *
     * @param orderId
     */
    @Override
    public void setterOrder(Integer orderId) {

        //订单使用的内部券
        List<CouponCustomerRelevance> innerCouponCustomerRelevanceServiceList = couponCustomerRelevanceService
                .list(new LambdaQueryWrapper<CouponCustomerRelevance>()
                        .eq(CouponCustomerRelevance::getOrderId, orderId)
                        .eq(CouponCustomerRelevance::getState, 1)
                        .eq(CouponCustomerRelevance::getType, 0));

        //订单使用的外部券
        List<CouponCustomerRelevance> outerCouponCustomerRelevanceServiceList = couponCustomerRelevanceService
                .list(new LambdaQueryWrapper<CouponCustomerRelevance>()
                        .eq(CouponCustomerRelevance::getOrderId, orderId)
                        .eq(CouponCustomerRelevance::getState, 1)
                        .eq(CouponCustomerRelevance::getType, 1));


        //订单使用的次卡
        List<TimesCardUsedRecord> timesCardUsedRecordList = timesCardUsedRecordService
                .list(new LambdaQueryWrapper<TimesCardUsedRecord>()
                        .eq(TimesCardUsedRecord::getOrderId, orderId)
                        .eq(TimesCardUsedRecord::getStatus, 1));


        //查询订单聚合
        OrderManage orderManage = orderManageMapper.selectById(orderId);
        List<OrderServe> orderServeList = orderServeMapper.selectList(new LambdaQueryWrapper<OrderServe>().eq(OrderServe::getOrderId, orderId));
        orderManage.setListOrderServer(orderServeList);

        //1.改价结算
        orderManage.setTotalPaymentAmount(orderManage.getTotalPrice().add(orderManage.getChangePrice()));
        orderManage.setDiscountPrice(BigDecimal.ZERO);

        orderManage.getListOrderServer().forEach(orderServe -> {
            orderServe.setPayPrice(orderServe.getPrice().add(orderServe.getServeChangePrice()));
            orderServe.setDiscountPrice(BigDecimal.ZERO);
            orderServe.setAchievement(orderServe.getPrice().add(orderServe.getServeChangePrice()));
        });


        //2.闲时折扣结算
        orderManage.getListOrderServer().forEach(orderServeDTO -> {
            orderServeDTO.setDiscountPrice(orderServeDTO.getLeisureDiscountPrice());
            orderServeDTO.setPayPrice(orderServeDTO.getPayPrice().subtract(orderServeDTO.getLeisureDiscountPrice()));

            orderManage.setTotalPaymentAmount(orderManage.getTotalPaymentAmount().subtract(orderServeDTO.getLeisureDiscountPrice()));
            orderManage.setDiscountPrice(orderManage.getDiscountPrice().add(orderServeDTO.getLeisureDiscountPrice()));
        });


        //3.次卡
        if (ListUtil.isNotEmpty(timesCardUsedRecordList)) {

            timesCardUsedRecordList.forEach(timesCardUsedRecord -> timesCardUsedRecord.setStatus(TimesCardUsedRecord.STATUS_CHOSE));

            timesCardOrderServeDetailMapper.delete(new LambdaQueryWrapper<TimesCardOrderServeDetail>()
                    .in(TimesCardOrderServeDetail::getTimesCardUserRecordId, timesCardUsedRecordList.stream().map(TimesCardUsedRecord::getId).collect(Collectors.toList())));

            timesCardUsedRecordList.stream()
                    .sorted(Comparator.comparing(TimesCardUsedRecord::getDiscountAmount))
                    .forEach(timesCardUsedRecord -> {

                        //次卡能用的服务id
                        List<Integer> serveIds = timesCardCustomerRelevanceMapper.queryTimesCardServeIds(timesCardUsedRecord.getCardTypeId());

                        //抵扣的服务为 作用范围内支付金额最高的服务
                        OrderServe orderServe = this.queryMaxPayPrice(orderManage, serveIds);

                        //更新次卡记录 已使用
                        timesCardUsedRecord.setStatus(TimesCardUsedRecord.STATUS_USED);
                        timesCardUsedRecord.setTechnicianName(orderServe.getTechnicianName());
                        timesCardUsedRecord.setDepartmentName(orderManage.getDepartmentName());
                        timesCardUsedRecord.setDepartmentId(orderManage.getDepartmentId());
                        timesCardUsedRecord.setServeName(orderServe.getServeName());
                        //次卡作用的服务id
                        timesCardUsedRecord.setOrderServeId(orderServe.getServeId());
                        timesCardUsedRecordService.updateById(timesCardUsedRecord);

                        //更新使用次数
                        TimesCardCustomerRelevance timesCardCustomerRelevance = timesCardCustomerRelevanceService.getById(timesCardUsedRecord.getCardRelevanceCustomerId());
                        timesCardCustomerRelevance.setUsedTimes(timesCardCustomerRelevance.getUsedTimes() + 1);
                        if (timesCardCustomerRelevance.getUsedTimes().equals(timesCardCustomerRelevance.getSumTimes())) {
                            //次数用完
                            timesCardCustomerRelevance.setStatus(2);
                        }
                        timesCardCustomerRelevanceService.updateById(timesCardCustomerRelevance);


                        //金额 业绩计算
                        BigDecimal minDiscountAmount = orderServe.getPayPrice().min(timesCardUsedRecord.getDiscountAmount());

                        orderServe.setDiscountPrice(orderServe.getDiscountPrice().add(minDiscountAmount));
                        orderServe.setPayPrice(orderServe.getPayPrice().subtract(minDiscountAmount));
                        orderServe.setAchievement(orderServe.getAchievement().subtract(minDiscountAmount));

                        orderManage.setDiscountPrice(orderManage.getDiscountPrice().add(minDiscountAmount));
                        orderManage.setTotalPaymentAmount(orderManage.getTotalPaymentAmount().subtract(minDiscountAmount));

                    });
        }

        //卡券之前删除订单服务和卡券关联
        couponOrderRelevanceService.remove(new LambdaQueryWrapper<CouponOrderRelevance>()
                .eq(CouponOrderRelevance::getOrderId, orderId));

        //4。外部券
        if (ListUtil.isNotEmpty(outerCouponCustomerRelevanceServiceList)) {

            //删除之前的外部券抵扣情况记录
            couponOrderRelevanceService.remove(new LambdaQueryWrapper<CouponOrderRelevance>()
                    .eq(CouponOrderRelevance::getOrderId, orderId)
                    .in(CouponOrderRelevance::getCouponCustomerRelevanceId, outerCouponCustomerRelevanceServiceList.stream().map(CouponCustomerRelevance::getId).collect(Collectors.toList())));


            outerCouponCustomerRelevanceServiceList
                    .stream()
                    .sorted(Comparator.comparing(CouponCustomerRelevance::getDiscountAmount).reversed())
                    .forEach(couponCustomerRelevance -> {

                        //外部券能用的服务id
                        List<Integer> serveIds = couponCustomerRelevanceMapper.queryCouponCustomerServeRelevance(couponCustomerRelevance.getCouponId());

                        //抵扣的服务为 作用范围内支付金额最高的服务
                        OrderServe orderServe = this.queryMaxPayPrice(orderManage, serveIds);

                        //新增外部券抵扣情况记录
                        CouponOrderRelevance couponOrderRelevance = CouponOrderRelevance.builder()
                                .couponCustomerRelevanceId(couponCustomerRelevance.getId())
                                .couponId(couponCustomerRelevance.getCouponId())
                                .couponName(couponCustomerRelevance.getCouponName())
                                .orderServeId(orderServe.getId())
                                .serveName(orderServe.getServeName())
                                .orderId(orderManage.getId())
                                //支付金额
                                .payForOrderServe(couponCustomerRelevance.getPayAmount())
                                //折扣金额
                                .discountAmount(couponCustomerRelevance.getDiscountAmount().min(orderServe.getPayPrice()))
                                .createTime(new Date())
                                .confirmTime(new Date())
                                .message(orderServe.getServeName())
                                .customerId(orderManage.getOrderUser())
                                .status(2)
                                .build();
                        couponOrderRelevanceService.save(couponOrderRelevance);


                        //金额 业绩计算
                        BigDecimal minDiscountAmount = orderServe.getPayPrice().min(couponCustomerRelevance.getDiscountAmount());

                        orderServe.setDiscountPrice(orderServe.getDiscountPrice().add(minDiscountAmount));
                        orderServe.setPayPrice(orderServe.getPayPrice().subtract(minDiscountAmount));

                        if (couponCustomerRelevance.getIsCalcAchievement() == 1) {
                            orderServe.setAchievement(orderServe.getAchievement().subtract(minDiscountAmount).add(couponCustomerRelevance.getPayAmount()));
                        }

                        orderManage.setDiscountPrice(orderManage.getDiscountPrice().add(minDiscountAmount));
                        orderManage.setTotalPaymentAmount(orderManage.getTotalPaymentAmount().subtract(minDiscountAmount));

                    });
        }
        //5.内部券
        if (ListUtil.isNotEmpty(innerCouponCustomerRelevanceServiceList)) {

            //删除之前的内部券抵扣情况记录
            couponOrderRelevanceService.remove(new LambdaQueryWrapper<CouponOrderRelevance>()
                    .eq(CouponOrderRelevance::getOrderId, orderId)
                    .in(CouponOrderRelevance::getCouponCustomerRelevanceId, innerCouponCustomerRelevanceServiceList.stream().map(CouponCustomerRelevance::getId).collect(Collectors.toList())));

            innerCouponCustomerRelevanceServiceList
                    .forEach(couponCustomerRelevance -> {
                        //内部券能用的服务id
                        List<Integer> serveIds = couponCustomerRelevanceMapper.queryCouponCustomerServeRelevance(couponCustomerRelevance.getCouponId());

                        //作用的服务id
                        List<OrderServe> canUserOrderServeList = orderManage.getListOrderServer().stream().filter(dto -> serveIds.contains(dto.getServeId())).collect(Collectors.toList());

                        //打折订单项总支付金额
                        BigDecimal total = canUserOrderServeList.stream().map(OrderServe::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add);

                        if (total.intValue() != 0) {
                            //卡券的总折扣金额
                            BigDecimal totalCouponDiscount = couponCustomerRelevance.getDiscountAmount();
                            //卡券总支付金额
                            BigDecimal totalCouponPay = couponCustomerRelevance.getPayAmount();

                            //计算参数（最后一个订单服务的折扣金额要用总折扣金额减 防止除法计算精度问题）
                            BigDecimal discountCalc = BigDecimal.ZERO;

                            //计算参数（最后一个订单服务的实际支付要用总实际支付金额减 防止除法计算精度问题）
                            BigDecimal payCalc = BigDecimal.ZERO;

                            for (OrderServe orderServe : canUserOrderServeList) {

                                //每个服务的内部券抵扣金额
                                BigDecimal discountAmount = orderServe.getPayPrice().multiply(totalCouponDiscount).divide(total, 2, BigDecimal.ROUND_HALF_UP);
                                //每个服务的内部券支付金额
                                BigDecimal payAmount = orderServe.getPayPrice().multiply(totalCouponPay).divide(total, 2, BigDecimal.ROUND_HALF_UP);

                                //最后一个服务使用总额减法而不是除法
                                if (canUserOrderServeList.lastIndexOf(orderServe) == canUserOrderServeList.size() - 1) {
                                    discountAmount = totalCouponDiscount.subtract(discountCalc);
                                    payAmount = totalCouponPay.subtract(payCalc);
                                }

                                //卡券在订单服务上的抵扣情况
                                CouponOrderRelevance couponOrderRelevance = CouponOrderRelevance.builder()
                                        .discountAmount(discountAmount.min(orderServe.getPayPrice()))
                                        //卡券在这个服务上的实际支付金额
                                        .payForOrderServe(payAmount)
                                        .createTime(new Date())
                                        .orderServeId(orderServe.getId())
                                        .orderId(orderManage.getId())
                                        .couponId(couponCustomerRelevance.getCouponId())
                                        .couponCustomerRelevanceId(couponCustomerRelevance.getId())

                                        .confirmTime(new Date())
                                        .message(orderServe.getServeName())
                                        .customerId(orderManage.getOrderUser())
                                        .status(2)
                                        .build();

                                //保存卡券在订单服务上的使用请款
                                couponOrderRelevanceService.save(couponOrderRelevance);


                                orderServe.setDiscountPrice(orderServe.getDiscountPrice().add(discountAmount));
                                orderServe.setPayPrice(orderServe.getPayPrice().subtract(payAmount));

                                if (couponCustomerRelevance.getIsCalcAchievement() == 1) {
                                    orderServe.setAchievement(orderServe.getAchievement().subtract(discountAmount).add(payAmount));
                                }

                                orderManage.setDiscountPrice(orderManage.getDiscountPrice().add(discountAmount));
                                orderManage.setTotalPaymentAmount(orderManage.getTotalPaymentAmount().subtract(payAmount));


                                discountCalc = discountCalc.add(discountAmount);
                                payCalc = payCalc.add(payAmount);
                            }
//                            //更新卡券使用情况 已使用
//                            couponCustomerRelevance.setState(CouponCustomerRelevance.STATE_USED);
//                            couponCustomerRelevanceService.updateById(couponCustomerRelevance);
                        }
                        //内部券抵扣不了
                        else {
                            couponCustomerRelevance.setState(null);
                            couponCustomerRelevance.setOrderId(null);
                            couponCustomerRelevanceService.updateById(couponCustomerRelevance);
                        }
                    });
        }

        orderManageMapper.updateById(orderManage);
        orderServeService.saveOrUpdateBatch(orderServeList);

    }

    /**
     * serviceIds 中支付金额最多的订单服务
     *
     * @param orderManage
     * @param serveIds
     * @return
     */
    private OrderServe queryMaxPayPrice(OrderManage orderManage, List<Integer> serveIds) {
        return orderManage.getListOrderServer()
                .stream()
                .filter(dto -> serveIds.contains(dto.getServeId()))
                .max(Comparator.comparing(OrderServe::getPayPrice))
                .orElseThrow(RRException::new);
    }
}
