package com.gogirl.interfaces.store.training;


import com.gogirl.application.store.training.ITrainingFeedbackService;
import com.gogirl.domain.store.training.TrainingFeedback;
import com.gogirl.infrastructure.common.base.JsonResult;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-07-07
 */
@RestController
@RequestMapping("/technician/trainingFeedback")
public class TrainingFeedbackController {

    @Resource
    private ITrainingFeedbackService trainingFeedbackService;

    @PostMapping("/submitTrainingFeedBack")
    public JsonResult<Void> submitTrainingFeedBack(@RequestBody TrainingFeedback trainingFeedback) {
        trainingFeedbackService.submitTrainingFeedBack(trainingFeedback);
        return JsonResult.success();
    }
}
