package com.gogirl.application.store.training.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.store.training.ITrainingStartClassLogTechnicianService;
import com.gogirl.domain.store.training.TrainingStartClass;
import com.gogirl.domain.store.training.TrainingStartClassLogTechnician;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.mapper.store.training.TrainingStartClassLogTechnicianMapper;
import com.gogirl.infrastructure.mapper.store.training.TrainingStartClassMapper;
import com.gogirl.infrastructure.util.SessionUtils;
import com.gogirl.shared.store.training.QueryPageStartClassLogRequest;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 每次开课，参与的美甲师 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-07-07
 */
@Service
public class TrainingStartClassLogTechnicianServiceImpl extends ServiceImpl<TrainingStartClassLogTechnicianMapper, TrainingStartClassLogTechnician> implements ITrainingStartClassLogTechnicianService {

    @Resource
    TrainingStartClassMapper trainingStartClassMapper;

    @Override
    public IPage<TrainingStartClassLogTechnician> queryPageStartClassLog(QueryPageStartClassLogRequest request) {

        Integer technicianId = SessionUtils.getTechnicianId();
        request.setTechnicianId(technicianId);
        IPage<TrainingStartClassLogTechnician> pageRequest = new Page<>(request.getPageNum(), request.getPageSize());
        IPage<TrainingStartClassLogTechnician> page = baseMapper.queryPageStartClassLog(pageRequest, request);

        List<Integer> ids = page.getRecords().stream().map(TrainingStartClassLogTechnician::getTrainingStartClassId).collect(Collectors.toList());
        if (ListUtil.isNotEmpty(ids)) {
            Map<Integer, TrainingStartClass> trainingStartClassesMap = trainingStartClassMapper.selectBatchIds(ids).stream().collect(Collectors.toMap(TrainingStartClass::getId, trainingStartClass -> trainingStartClass, (k1, k2) -> k1));
            page.getRecords().forEach(trainingStartClassLogTechnician -> {
                trainingStartClassLogTechnician.setTrainingStartClass(trainingStartClassesMap.get(trainingStartClassLogTechnician.getTrainingStartClassId()));
            });
        }

        return page;
    }
}
