package com.gogirl.application.store.training.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.store.training.ITrainingFeedbackDetailService;
import com.gogirl.application.store.training.ITrainingFeedbackService;
import com.gogirl.domain.store.training.TrainingFeedback;
import com.gogirl.infrastructure.mapper.store.training.TrainingFeedbackMapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-07-07
 */
@Service
public class TrainingFeedbackServiceImpl extends ServiceImpl<TrainingFeedbackMapper, TrainingFeedback> implements ITrainingFeedbackService {

    @Resource
    private ITrainingFeedbackDetailService trainingFeedbackDetailService;

    @Override
    public void submitTrainingFeedBack(TrainingFeedback trainingFeedback) {
        this.save(trainingFeedback);

        trainingFeedback.getTrainingFeedbackDetailList().forEach(trainingFeedbackDetail -> {
            trainingFeedbackDetail.setTrainingFeedbackId(trainingFeedback.getId());
        });
        trainingFeedbackDetailService.saveBatch(trainingFeedback.getTrainingFeedbackDetailList());
    }
}
