package com.gogirl.infrastructure.subscribe.impl;

import com.gogirl.application.xcx.impl.AccessTokenService;
import com.gogirl.infrastructure.config.property.WxProperties;
import com.gogirl.infrastructure.feign.wx.WxSubscribeControllerFeign;
import com.gogirl.infrastructure.subscribe.SubscribeService;
import com.gogirl.shared.wx.*;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @Author robbendev
 * @Description //TODO
 * @Date 2019/12/29
 **/
@Service
@AllArgsConstructor
@Slf4j
public class SubscribeServiceImpl implements SubscribeService {

    private final WxSubscribeControllerFeign wxSubscribeControllerFeign;
    private final AccessTokenService accessTokenService;
    private final WxProperties wxProperties;

    @Async
    @Override
    public void sendScheduleMsg(String openId, String scheduleName, Date arriveTime, String departmentName, String address) {

        String tips = "距预约剩余1小时，请准时到店，超时将取消";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        wxSubscribeControllerFeign.send(WxSubscribeMessageRequest.builder()
                .toUser(openId)
                .accessToken(accessTokenService.getAccessToken().getAccessToken())
                .page("pages/mine/appointment-list")
                .templateId(wxProperties.getScheduleTpl())
                .data(ScheduleSubscribeMsgData.builder()
                        //预约时间
                        .time2(new MessageValue(sdf.format(arriveTime)))
                        //地址
                        .thing4(new MessageValue(address))
                        //预约项目
                        .thing7(new MessageValue(scheduleName))
                        //预约门店
                        .thing8(new MessageValue(departmentName))
                        //温馨提示
                        .thing9(new MessageValue(tips))
                        .build())
                .build());
    }


    @Async
    @Override
    public void sendOverScheduleMsg(String openId,
                                    String scheduleName,
                                    Date arriveTime,
                                    String departmentName,
                                    String address) {

        String tips = "您已超时15分钟，预约已取消，请重新预约";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        wxSubscribeControllerFeign.send(WxSubscribeMessageRequest.builder()
                .toUser(openId)
                .accessToken(accessTokenService.getAccessToken().getAccessToken())
                .page("pages/mine/appointment-list")
                //模板id
                .templateId(wxProperties.getOverScheduleTpl())
                .data(OverScheduleSubscribeMsgData.builder()
                        //预约时间
                        .date2(new MessageValue(sdf.format(arriveTime)))
                        //门店地址
                        .thing4(new MessageValue(address))
                        //预约项目
                        .thing1(new MessageValue(scheduleName))
                        //预约门店
                        .thing3(new MessageValue(departmentName))
                        //温馨提示
                        .thing5(new MessageValue(tips))
                        .build())
                .build());

    }


    @Async
    @Override
    public void sendPaySuccessMsg(Integer orderId,
                                  String openId,
                                  String payType,
                                  Date paymentTime,
                                  BigDecimal paymentAmount,
                                  BigDecimal balance) {

        String tips = "点击即可查看详情，如有疑问请联系客服";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        wxSubscribeControllerFeign.send(WxSubscribeMessageRequest.builder()
                .toUser(openId)
                .accessToken(accessTokenService.getAccessToken().getAccessToken())
                .page("pages/mine/serve-details")
                //模板id
                .templateId(wxProperties.getPaySuccessTpl())
                .data(PaySuccessSubscribeMsgData.builder()
                        //支付时间
                        .date5(new MessageValue(sdf.format(paymentTime)))
                        //金额
                        .amount3(new MessageValue("￥" + paymentAmount.toString()))
                        //支付方式
                        .thing7(new MessageValue(payType))
                        //会员余额
                        .amount8(new MessageValue("￥" + balance.toString()))
                        //温馨提示
                        .thing9(new MessageValue(tips))
                        .build())
                .build());

    }

    @Async
    @Override
    public void sendOrderPayNotifyMsg(Integer orderId,
                                      String openId,
                                      String serveName,
                                      String orderNo,
                                      BigDecimal paymentAmount,
                                      String customerName) {

        String tips = "亲，支付完成后请给店员确认哦，谢谢！";
        wxSubscribeControllerFeign.send(WxSubscribeMessageRequest.builder()
                .toUser(openId)
                .accessToken(accessTokenService.getAccessToken().getAccessToken())
                .page("pages/mine/serve-details?orderId=" + orderId)
                //模板id
                .templateId(wxProperties.getOrderPayNotifyTpl())
                .data(OrderNotifySubscribeMsgData.builder()
                        //订单号
                        .character_string4(new MessageValue(orderNo))
                        //金额
                        .amount3(new MessageValue("￥" + paymentAmount.toString()))
                        //服务名称
                        .thing1(new MessageValue(serveName))
                        //温馨提示
                        .thing6(new MessageValue(tips))
                        .build())

                .build());
    }


    @Override
    public void testPaper(String openId,
                          Integer orderId) {
        wxSubscribeControllerFeign.send(WxSubscribeMessageRequest
                .builder()
                .toUser(openId)
                .accessToken(accessTokenService.getAccessToken().getAccessToken())
                .page("pages/mine/comment?orderId=" + orderId)
                //模板id
                .templateId(wxProperties.getTestPaperTpl())
                .data(TestPaperMsgData.builder()
                        .thing1(new MessageValue("评价有礼"))
                        .amount2(new MessageValue("￥10"))
                        .thing3(new MessageValue("点击进入小程序评价服务即可领取成功哦！"))
                        .build())
                .build());

    }

}
