package com.gogirl.domain.store.training;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.gogirl.infrastructure.common.annotation.DictParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

@TableName("training_start_class")
@AllArgsConstructor
@NoArgsConstructor
@Data
public class TrainingStartClass implements Serializable {

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("课程id")
    private Integer courseId;

    @ApiModelProperty("讲师")
    private String lecturer;

    @ApiModelProperty("上课时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime time;

    @ApiModelProperty("时长")
    private Integer duration;

    @DictParam(dictCode = "TRAINING_START_CLASS_STATUS", dictValueParam = "statusStr")
    @ApiModelProperty("状态 1-待开课 2-已开课 3-已结束")
    private Integer status;

    @TableField(exist = false)
    @ApiModelProperty("状态 1-待开课 2-已开课 3-已结束")
    private Integer statusStr;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("课程")
    @TableField(exist = false)
    private TrainingCourse trainingCourse;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty("学员反馈")
    private String feedback;

    @ApiModelProperty("图片")
    private String picturePath;

    @ApiModelProperty("培训地址")
    private String address;
}
