package com.gogirl.assembler;

import com.gogirl.domain.store.training.TrainingStartClass;
import com.gogirl.shared.store.TrainingCourseDTO;
import com.gogirl.shared.store.TrainingStartClassDTO;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

import java.util.function.Function;

@Component
public class TrainingStartClassDTOAssembler implements Function<TrainingStartClass, TrainingStartClassDTO> {

    @Override
    public TrainingStartClassDTO apply(TrainingStartClass trainingStartClass) {
        TrainingStartClassDTO trainingStartClassDTO = new TrainingStartClassDTO();
        BeanUtils.copyProperties(trainingStartClass, trainingStartClassDTO);

        if (trainingStartClass.getTrainingCourse() != null) {
            TrainingCourseDTO trainingCourseDTO = new TrainingCourseDTO();
            BeanUtils.copyProperties(trainingStartClass.getTrainingCourse(), trainingCourseDTO);
            trainingStartClassDTO.setTrainingCourseDTO(trainingCourseDTO);
        }
        return trainingStartClassDTO;
    }
}
