package com.gogirl.application.order.purchase.impl;

import com.gogirl.application.order.purchase.PurchaseOrderCmdService;
import com.gogirl.domain.order.purchase.PurchaseOrder;
import com.gogirl.domain.product.purchase.PurchaseSku;
import com.gogirl.domain.store.store.StoreManage;
import com.gogirl.infrastructure.mapper.product.purchase.PurchaseSkuMapper;
import com.gogirl.infrastructure.mapper.order.purchase.PurchaseOrderMapper;
import com.gogirl.infrastructure.mapper.store.store.StoreManageMapper;
import com.gogirl.shared.member.CreatePurchaseOrderCommand;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;


@Service
@AllArgsConstructor
public class PurchaseOrderCmdServiceImpl implements PurchaseOrderCmdService {


    private final PurchaseOrderMapper purchaseOrderMapper;

    private final StoreManageMapper storeManageMapper;

    private final PurchaseSkuMapper purchaseSkuMapper;

    @Override
    public void createPurchaseOrder(List<CreatePurchaseOrderCommand> cmdList) {

        cmdList.forEach(cmd -> {
            PurchaseSku purchaseSku = purchaseSkuMapper.selectById(cmd.getPurchaseSkuId());

            StoreManage storeManage = storeManageMapper.selectById(cmd.getCreateDepartmentId());

            PurchaseOrder purchaseOrder = PurchaseOrder.builder()
                    .createRemark(cmd.getCreateRemark())
                    .createDepartmentId(cmd.getCreateDepartmentId())
                    .creater(cmd.getCreater())
                    .createrName(cmd.getCreaterName())

                    //寄到哪个店铺
                    .departmentId(cmd.getCreateDepartmentId())
                    .departmentName(storeManage.getName())
                    .price(purchaseSku.getPurchasePrice())
                    .shopPrice(purchaseSku.getShopPrice())
                    .quantity(cmd.getQuantity())
                    .sku(purchaseSku.getSku())
                    .skuName(purchaseSku.getSkuName())
                    .skuPicturePath(purchaseSku.getPicturePath())
//                .skuTypeName(purchaseSkuDTO.getSkuType())
                    .createTime(new Date())
                    .status(1)
                    .build();

            purchaseOrderMapper.insert(purchaseOrder);
        });
    }
}
