package com.gogirl.application.order.mall;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.gogirl.domain.order.mall.MallOrder;
import com.gogirl.shared.market.SubmitMallOrderCommand;
import com.gogirl.shared.member.ImmediatePurchaseCommand;
import com.gogirl.shared.order.CancelMallOrderCommand;
import com.gogirl.shared.order.MallOrderDTO;
import com.gogirl.shared.order.SettleMallOrderQuery;


public interface MallOrderService extends IService<MallOrder> {


    /**
     * 查询订单聚合列表
     *
     * @param page      分页参数
     * @param mallOrder 订单查询参数
     * @return
     */
    IPage<MallOrder> listMallOrderAggregate(Page<MallOrder> page, MallOrder mallOrder);


    /**
     * 查询订单聚合
     *
     * @param mallOrderId
     * @return
     */
    MallOrder getMallOrderAggregate(Long mallOrderId);


    /**
     * 订单确认收货
     *
     * @param currentCustomerId
     * @param mallOrderId
     */
    void takeDeliveryOfMallOrder(Integer currentCustomerId, Long mallOrderId);

    /**
     * 保存订单聚合
     *
     * @param mallOrder
     * @return
     */
    MallOrder saveAggregate(MallOrder mallOrder);

    /**
     * 提交订单
     *
     * @param cmd
     */
    void submitMallOrder(SubmitMallOrderCommand cmd);

    /**
     * 用户取消订单
     *
     * @param cmd
     */
    void cancelMallOrder(CancelMallOrderCommand cmd);

    /**
     * 立即购买
     *
     * @param cmd
     */
    void immediatePurchase(ImmediatePurchaseCommand cmd);

    /**
     * @param qry
     * @return
     */
    MallOrderDTO querySettleMalOrder(SettleMallOrderQuery qry);
}
