package com.gogirl.domain.product.purchase;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel("采购sku表")
@TableName("purchase_sku")
@Data
public class PurchaseSku implements Serializable {

    @TableId(type = IdType.AUTO)
    @ApiModelProperty("采购id")
    private Integer id;

    @ApiModelProperty("sku码")
    private String sku;

    @ApiModelProperty("商品图")
    private String images;

    @ApiModelProperty("商品详情图")
    private String detailImages;

    @ApiModelProperty("商品描述")
    private String description;

    @ApiModelProperty("图片路径,用逗号隔开多张图片")
    private String picturePath;

    @ApiModelProperty("商品名字")
    private String skuName;

    @ApiModelProperty("purchase_sku_type.id")
    private Integer skuType;

    @ApiModelProperty("商品型号描述")
    private String skuModel;

    @ApiModelProperty("店铺看到的价格")
    private BigDecimal shopPrice;

    @ApiModelProperty("采购价格")
    private BigDecimal purchasePrice;

    @ApiModelProperty("供应商")
    private String supplier;

    @ApiModelProperty("商品类型:1.店用;2.店用+售卖")
    private Integer useType;

    @ApiModelProperty("系列id")
    private Integer seriesId;

    @ApiModelProperty("采购id")
    private Integer ppsParentId;

    @ApiModelProperty("产品编码")
    private String ppsSku;

    @ApiModelProperty("是否多属性")
    private Boolean ppsMultiattribute;

    @ApiModelProperty("产品库类目Id")
    private Integer ppsCategoryId;

    @ApiModelProperty("产品库类目")
    private String ppsCategoryName;

    @ApiModelProperty("商城类目")
    private Integer ppsShoppingMallCategoryId;

    @ApiModelProperty("商城类目")
    private String ppsShoppingMallCategoryName;

    @ApiModelProperty("商品标题")
    private String ppsGoodsTitle;

    @ApiModelProperty("特征描述")
    private String ppsDescription;

    @ApiModelProperty("原价")
    private BigDecimal ppsOriginalPrice;

    @ApiModelProperty("会员价")
    private BigDecimal ppsMemberPrice;

    @ApiModelProperty("折扣价/秒杀价")
    private BigDecimal ppsDiscountPrice;

    @ApiModelProperty("商品图片")
    private String ppsPicturePath;

    @ApiModelProperty("视频")
    private String ppsVedioPath;

    @ApiModelProperty("采购id")
    private String ppsDetails;

    @ApiModelProperty("品牌")
    private String ppsBrand;

    @ApiModelProperty("色号")
    private String ppsColorNumber;

    @ApiModelProperty("色名")
    private String ppsColorName;

    @ApiModelProperty("规格/容量")
    private String ppsSpecs;

    @ApiModelProperty("尺寸")
    private String ppsSize;

    @ApiModelProperty("重量")
    private Double ppsWeight;

    @ApiModelProperty("计量单位")
    private String ppsUnit;

    @ApiModelProperty("物流说明")
    private String ppsLogisticsDescription;

    @ApiModelProperty("保障说明")
    private String ppsGuaranteeInstruction;

    @ApiModelProperty("售后说明")
    private String ppsAfterSaleInstructions;

    @ApiModelProperty("0 = 系统添加 1= 刊登系统推送 2= 百伦产品库拉取")
    private Integer source;

    @ApiModelProperty("色值")
    private String colorValue;

    @ApiModelProperty("颜色描述")
    private String colorName;

    @ApiModelProperty("色球图片")
    private String colorImgPath;

    @ApiModelProperty("最小订单量")
    private BigDecimal ppsMoq;

    @ApiModelProperty("颜色id")
    private Integer colorId;
}
