package com.gogirl.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gogirl.domain.store.store.StoreTechnician;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;

@Data
public class LeisureScheduleServe {

    private Integer leisureDiscountConfigId;

    private BigDecimal discountRate;

    private Integer departmentId;

    @JsonFormat(pattern = "HH:mm:ss")
    private LocalTime timeNode;

    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate weekDate;

    private Integer serveId;

    private String serveName;

    private String departmentName;

    private Double latitude;

    private Double longitude;

    private Double distance;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime dateTime;

    private List<StoreTechnician> storeTechnicianList;
}
