package com.gogirl.domain.user.customer;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.gogirl.domain.order.serve.OrderManage;
import com.gogirl.domain.store.store.StoreUser;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.Date;


@ApiModel("会员卡消费记录")
@TableName("customer_balance_record")
@Data
@Builder
@AllArgsConstructor
public class CustomerBalanceRecord {

    public static final Integer TYPE_MALL_ORDER = 3;
    //1:充值，2:首次充值，3:商城订单扣款:,-1:预约订单扣款
    public static final Integer TYPE_CHARGE = 1;
    public static final Integer TYPE_FIRST_CHARGE = 2;
    public static final Integer TYPE_MALL_ORDER_CONSUME = 3;
    public static final Integer TYPE_SCHEDULE_ORDER_CONSUME = -1;
    //    @ApiModelProperty("钱去到哪里了：1:用户端微信支付,2:会员卡收款,3:其他(目前没用到)," +
    //            "4:用户端微信支付充值,5:pos收款," +
    //            "6:现金收款,7:大众点评收款,8:微信扫码支付,9:团购," +
    //            "10:免单，11:")
    public static final Integer SOURCE_WX = 1;
    public static final Integer SOURCE_BALANCE = 2;
    public static final Integer SOURCE_OTHER = 3;
    @TableId(type = IdType.AUTO)
    private Integer id;
    @ApiModelProperty("客户id")
    private Integer customerId;
    private Integer oldBalance;
    @ApiModelProperty("钱去到哪里了：1:用户端微信支付,2:会员卡收款,3:其他(目前没用到)," +
            "4:用户端微信支付充值,5:pos收款," +
            "6:现金收款,7:大众点评收款,8:微信扫码支付,9:团购," +
            "10:免单，11:")
    private Integer source;
    @ApiModelProperty("这笔记录来自于哪里：1:充值，2:首次充值，3:商城订单扣款:,-1:预约订单扣款")
    private Integer type;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date time;
    @ApiModelProperty("当前余额")
    private Integer currentBalance;
    @ApiModelProperty("该笔记录金额")
    private Integer orderAmount;
    @ApiModelProperty("新版本订单id,原order_id没用了")
    private Integer newOrderId;
    private Double discount;
    @ApiModelProperty("赠送金额")
    private Integer bestowAmount;
    private String orderId;
    @ApiModelProperty("订单状态")
    private Integer orderState;
    private String ip;
    @ApiModelProperty("备注")
    private String remark;
    @ApiModelProperty("充值推荐人，美甲师id")
    private String refereeId;
    @ApiModelProperty("店铺id")
    private Integer departmentId;
    /**
     * 非数据库字段
     */
    @TableField(exist = false)
    private StoreUser referee;
    @TableField(exist = false)
    private String departmentName;
    @TableField(exist = false)
    @ApiModelProperty("消费订单详情")
    private OrderManage orderManage;

    public CustomerBalanceRecord() {

    }

    public CustomerBalanceRecord(Integer customerId, Integer source,
                                 Integer type, Date time, Integer currentBalance,
                                 Integer orderAmount, String orderId, Integer orderState, Double discount, Integer bestowAmount, String remark) {
        super();
        this.customerId = customerId;
        this.source = source;
        this.type = type;
        this.time = time;
        this.currentBalance = currentBalance;
        this.orderAmount = orderAmount;
        this.orderId = orderId;
        this.orderState = orderState;
        this.discount = discount;
        this.bestowAmount = bestowAmount;
        this.remark = remark;
    }
}
