package com.gogirl.interfaces.order.serve;


import com.gogirl.application.order.serve.IOwnProduceService;
import com.gogirl.domain.order.serve.OwnProduce;
import com.gogirl.domain.product.serve.TechniqueSku;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.shared.order.OwnProduceCommand;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-05-27
 */
@Api(tags = "'自带款式接口")
@RestController
public class OwnProduceController {

    @Resource
    IOwnProduceService ownProduceService;

    @ApiOperation("新增或者更新自带款式技法")
    @PostMapping("/technician/ownProduce/saveOrUpdateOwnProduce")
    public JsonResult<OwnProduce> saveOrUpdateOwnProduce(@RequestBody OwnProduceCommand command, @RequestHeader("brandId") Integer brandId) {
        command.setBrandId(brandId);
        OwnProduce ownProduce = ownProduceService.saveOrUpdateOwnProduce(command);
        return JsonResult.success(ownProduce);
    }

    @ApiOperation("查询已经选择的技法sku")
    @GetMapping("/technician/ownProduce/getByOwnProduceId")
    public JsonResult<List<TechniqueSku>> getByOwnProduceId(@RequestParam Integer ownProduceId) {
        List<TechniqueSku> list = ownProduceService.getByOwnProduceId(ownProduceId);
        return JsonResult.success(list);
    }

}
