package com.gogirl.infrastructure.mapper.product.serve;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.gogirl.domain.product.serve.BaseFeatures;
import org.apache.ibatis.annotations.Param;

import java.util.List;


public interface BaseFeaturesMapper extends BaseMapper<BaseFeatures> {

    /**
     * <p>
     * 查询款式的标签列表
     * </p>
     *
     * @param serveTypeId
     * @return
     */
    List<BaseFeatures> queryProduceFeatures(@Param("serveTypeId") Integer serveTypeId, @Param("brandId") Integer brandId);

    /**
     * <p>
     * 查询服务的标签列表
     * </p>
     *
     * @param serveTypeId
     * @return
     */
    List<BaseFeatures> queryServeFeatures(@Param("serveTypeId") Integer serveTypeId, @Param("brandId") Integer brandId);

    /**
     * <p>
     * 查询指定款式对应的首页标签列表
     *
     * </p>
     *
     * @param id
     * @return
     */
    List<BaseFeatures> queryProduceFeaturesById(Integer id);
}


