package com.gogirl.domain.store.training;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="TrainingQuestion对象", description="")
public class TrainingQuestion implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "问题")
    private String question;

    @ApiModelProperty(value = "排序")
    private Integer sort;

    @ApiModelProperty(value = "问题类型 1-选择题 2-填空题")
    private Integer type;

    @ApiModelProperty(value = "是否启用 1-是 2-否")
    private Integer enable;

    private LocalDateTime createTime;

    private LocalDateTime lastUpdateTime;

    @ApiModelProperty("品牌ID")
    private Integer brandId;

    @TableField(exist = false)
    private List<TrainingQuestionOption> trainingQuestionOptionList;


}
